/* toggle.h
 *
 * This file contains the global definitions, structures, and variables
 * used by the toggle test application.
 *
 */


/*** DEFINES ***/

#define TABLE_SIZE 3000
#define BUFFER_SIZE 100
#define BIG_STRING 1024



/*** STRUCTURES ***/

typedef struct t_tg_name
        {
           char *name;
           struct t_tg_name *next;
        } s_tg_name, *p_tg_name;

typedef struct t_tg_net
        {
           int used;
           handle net_handle;
           char *full_name;
           int one_to_zero;
           int zero_to_one;
           int num_ports;
           struct t_tg_name *ports;
           struct t_tg_net *next;
        } s_tg_net, *p_tg_net;

typedef struct t_tg_buff_ele
        {
           struct t_tg_net *net;
           unsigned char value;
        } s_tg_buff_ele, *p_tg_buff_ele;



/*** GLOBAL VARIABLES ***/

int toggle_test_invoked;             /* global flag that indicates whether or
                                        not the toggle test application has
                                        been invoked */
s_tg_net tg_nets[TABLE_SIZE];        /* array of simulated nets (hash table) */
s_tg_buff_ele tg_buffer[BUFFER_SIZE];  /* toggle data buffer */
int tg_curr_buff_ele;                /* current buffer element */
int tg_num_mon_nets;                 /* number of monitored nets */
int tg_num_mon_port_bits;            /* number of monitored port bits */
int tg_toggled_nets;                 /* number of nets that have toggled */
int tg_toggled_port_bits;            /* number of port bits that have toggled */


#if defined(__STDC__) || defined(__cplusplus)
#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <unistd.h>
#include <time.h>
#include <sys/types.h>
#endif

#include "acc_user.h"
#include "veriuser.h"

#if defined(__STDC__) || defined(__cplusplus)

#ifndef PROTO_PARAMS
#define PROTO_PARAMS(params) params
#define DEFINED_PROTO_PARAMS
#endif
#ifndef EXTERN
#define EXTERN
#define DEFINED_EXTERN
#endif

#else

#ifndef PROTO_PARAMS
#define PROTO_PARAMS(params) (/* nothing */)
#define DEFINED_PROTO_PARAMS
#endif
#ifndef EXTERN
#define EXTERN extern
#define DEFINED_EXTERN
#endif

#endif /* __STDC__ */
