/******************************************************************
 * NOTICE: The information contained in this file is proprietary  *
 * to Gateway Design Automation Corp. and is being made available *
 * to Gateway's customers under strict non-disclosure agreements. *
 * Use or disclosure of this information is permissible only      *
 * under the terms of the existing non-disclosure agreement.      *
 ******************************************************************/

/****************************************************************
 *     WAVEFORM DISPLAY AND REGISTER DISPLAY SETUP              *
 *     FOR THE SIO85 DEMONSTRATION                              *
 *                                                              *
 *     Use the command                                          *
 *         verilog sio85.v sio85_wr.v                           *
 *     to run the demonstration                                 *
 ****************************************************************/


// define scope levels
`define top s85
`define m85 s85.i85
`define mp1 s85.p1
`define mp2 s85.t1.p2
`define mtest s85.t1


module sio85_waves;
initial begin
     $gr_waves_memsize(500000);
     $gr_regs_memsize(500000);
     setup_waves;
end

task setup_waves;
begin
    $gr_waves(
"clock", `top.clock,
"s0",`top.s0, "ale",`top.ale,
"ad",`top.ad, "a",`top.a,
"pclock", `top.pclock, "rxd",`top.rxd, "txd",`top.txd,
"read",`top.read, "write",`top.write, "iomout",`top.iomout,
"trap",`top.trap,
"rst7p5",`top.rst7p5, "rst6p5",`top.rst6p5, "rst5p5",`top.rst5p5,
"intr",`top.intr, "ready",`top.ready, "nreset",`top.nreset, "hold",`top.hold,
"cc",`m85.cc, "cz",`m85.cz, "cs",`m85.cs, "cp",`m85.cp, "cac",`m85.cac,
"acc",`m85.acc,
"regb",`m85.regb,"regc",`m85.regc,
"regd",`m85.regd,"rege",`m85.rege,
"regh",`m85.regh,"regl",`m85.regl,
"sp",`m85.sp, "pc",`m85.pc, "ir",`m85.ir,
"dflags",`m85.dflags,
"addr",`m85.addr,
"data",`m85.data,
"intmask",`m85.intmask,
"aleff",`m85.aleff,
"s0ff", `m85.s0ff,     
"s1ff",`m85.s1ff,     
"hldaff",`m85.hldaff,   
"holdff",`m85.holdff,   
"intaff",`m85.intaff,   
"trapff",`m85.trapff,   
"trapi",`m85.trapi,    
"inte",`m85.inte,     
"int",`m85.int,      
"validint",`m85.validint, 
"haltff",`m85.haltff,   
"resetff",`m85.resetff,  
"clockff",`m85.clockff,  
"sodff",`m85.sodff,    
"85read",`m85.read,     
"85write",`m85.write,    
"iomff",`m85.iomff,    
"acontrol",`m85.acontrol, 
"dcontrol",`m85.dcontrol, 
"s",`m85.s,        
"txd",`mp1.txd,
"txrdy",`mp1.txrdy,
"rxrdy",`mp1.rxrdy,
"txe",`mp1.txe,
"dtr_",`mp1.dtr_,
"rts_",`mp1.rts_,
"receivebuf",`mp1.receivebuf,
"status",`mp1.status,
"recvdrv",`mp1.recvdrv,
"statusdrv",`mp1.statusdrv,
"command",`mp1.command,
"transmbuf",`mp1.transmbuf,
"sync1",`mp1.sync1, "sync2",`mp1.sync2,
"tdata",`mp1.tdata,
"modreg",`mp1.modreg,
"txd",`mp2.txd,
"txrdy",`mp2.txrdy,
"rxrdy",`mp2.rxrdy,
"txe",`mp2.txe,
"dtr_",`mp2.dtr_,
"rts_",`mp2.rts_,
"receivebuf",`mp2.receivebuf,
"status",`mp2.status,
"recvdrv",`mp2.recvdrv,
"statusdrv",`mp2.statusdrv,
"command",`mp2.command,
"transmbuf",`mp2.transmbuf,
"sync1",`mp2.sync1, "sync2",`mp2.sync2,
"tdata",`mp2.tdata,
"modreg",`mp2.modreg,
"senddata",`mtest.senddata, "senddata",`mtest.senddata,
"sendflag",`mtest.sendflag,
"pchperiod",pc.pchperiod);
    $define_group_waves(1, "i85", 
        "clock",
        "s0", "ale",
        "ad", "a",
        "read", "write", "iomout",
        "ready", "nreset", "hold",,
        "sp", "pc", "ir",
        "acc",
        "regb","regc",
        "regd","rege",
        "regh","regl");
end
endtask
endmodule




module sio85_regs;
initial begin
    setup_regs;
end

task setup_regs;
    $gr_regs(
"                TOP LEVEL MODULE",
"                ----------------",
"",
"        s0 %b   ale %b    rxd %b   txd %b",
"        ad %h     a %h",
"        read %b      write %b      iomout %b",
"        trap %b      rst7p5 %b rst6p5 %b rst5p5 %b",
"        intr %b      ready %b  nreset %b   hold %b",
"",
`top.s0, `top.ale, `top.rxd, `top.txd,
`top.ad, `top.a,
`top.read, `top.write, `top.iomout,
`top.trap, `top.rst7p5, `top.rst6p5, `top.rst5p5,
`top.intr, `top.ready, `top.nreset, `top.hold,
"",
"                8085 REGISTERS",
"                --------------",
"",
"        C Z M E I    ACC    B C   D E   H L",
"        %b%b%b%b%b   %h    %h%h  %h%h  %h%h",
"",
"        STACK %h      PC %h       IR %h",
`m85.cc, `m85.cz, `m85.cs, `m85.cp, `m85.cac,
`m85.acc, `m85.regb,`m85.regc, `m85.regd,`m85.rege, `m85.regh,`m85.regl,
`m85.sp, `m85.pc, `m85.ir,
"",
"  dflags[8:1]: %b",
"  (1=trace instructions, 2=trace IN and OUT",
`m85.dflags,
"",
"                             addr, address output %h",
"                                data, data output %h",
"               intmask, interrupt mask and status %h",
"                      aleff, address latch enable %h",
"                              s0ff, status line 0 %h",
"                              s1ff, status line 1 %h",
"                         hldaff, hold acknowledge %h",
"                            holdff, internal hold %h",
"                    intaff, interrupt acknowledge %h",
"                   trapff, trap interrupt request %h",
"        trapi, trap execution for RIM instruction %h",
"    inte, previous state of interrupt enable flag %h",
"           int, interrupt acknowledge in progress %h",
"                      validint, interrupt pending %h",
"                             haltff, halt request %h",
"                            resetff, reset output %h",
"                            clockff, clock output %h",
"                        sodff, serial output data %h",
"                        read, read request signal %h",
"                      write, write request signal %h",
"                         iomff, i/o memory select %h",
"                 acontrol, address output control %h",
"                    dcontrol, data output control %h",
"                           s, data source control %h",
"",
`m85.addr,
`m85.data,     
`m85.intmask,
`m85.aleff,    
`m85.s0ff,     
`m85.s1ff,     
`m85.hldaff,   
`m85.holdff,   
`m85.intaff,   
`m85.trapff,   
`m85.trapi,    
`m85.inte,     
`m85.int,      
`m85.validint, 
`m85.haltff,   
`m85.resetff,  
`m85.clockff,  
`m85.sodff,    
`m85.read,     
`m85.write,    
`m85.iomff,    
`m85.acontrol, 
`m85.dcontrol, 
`m85.s,        
"",
"",
"",
"               LOCAL 8251 (s85.p1)",
"               -------------------",
"",
"                                     txd %h",
"                                   txrdy %h",
"                                   rxrdy %h",
"                                     txe %h",
"                                    dtr_ %h",
"                                    rts_ %h",
"                              receivebuf %b",
"                                  status %h",
"                                 recvdrv %h",
"                               statusdrv %h",
"                                 command %h",
"                               transmbuf %b",
"    sync1, sync2, synchronous data bytes %h %h",
"           tdata, transmit data register %h",
"                                  modreg %h",
"",
`mp1.txd,
`mp1.txrdy,
`mp1.rxrdy,
`mp1.txe,
`mp1.dtr_,
`mp1.rts_,
`mp1.receivebuf,
`mp1.status,
`mp1.recvdrv,
`mp1.statusdrv,
`mp1.command,
`mp1.transmbuf,
`mp1.sync1, `mp1.sync2,
`mp1.tdata,
`mp1.modreg,
"",
"                REMOTE 8251 (s85.t1.p2)",
"                -----------------------",
"",
"                                     txd %h",
"                                   txrdy %h",
"                                   rxrdy %h",
"                                     txe %h",
"                                    dtr_ %h",
"                                    rts_ %h",
"                              receivebuf %b",
"                                  status %h",
"                                 recvdrv %h",
"                               statusdrv %h",
"                                 command %h",
"                               transmbuf %b",
"    sync1, sync2, synchronous data bytes %h %h",
"           tdata, transmit data register %h",
"                                  modreg %h",
"",
`mp2.txd,
`mp2.txrdy,
`mp2.rxrdy,
`mp2.txe,
`mp2.dtr_,
`mp2.rts_,
`mp2.receivebuf,
`mp2.status,
`mp2.recvdrv,
`mp2.statusdrv,
`mp2.command,
`mp2.transmbuf,
`mp2.sync1, `mp2.sync2,
`mp2.tdata,
`mp2.modreg,
"",
"    TEST 8251 MODULE  senddata %b",
"                      sendflag %b",
`mtest.senddata, `mtest.sendflag,
"",
"    SERIAL INTERFACE CLOCK PERIOD %d",
pc.pchperiod,
    );
endtask
endmodule


