/*
 * |-----------------------------------------------------------------------|
 * |                                                                       |
 * |   Copyright Cadence Design Systems, Inc. 1985, 1988.                  |
 * |     All Rights Reserved.       Licensed Software.                     |
 * |                                                                       |
 * |                                                                       |
 * | THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CADENCE DESIGN SYSTEMS |
 * | The copyright notice above does not evidence any actual or intended   |
 * | publication of such source code.                                      |
 * |                                                                       |
 * |-----------------------------------------------------------------------|
 */

/*
 * |-------------------------------------------------------------|
 * |                                                             |
 * | PROPRIETARY INFORMATION, PROPERTY OF CADENCE DESIGN SYSTEMS |
 * |                                                             |
 * |-------------------------------------------------------------|
 */

#ifndef VXL_ACC_USER_H
#define VXL_ACC_USER_H

/*---------------------------------------------------------------------------*/
/*------------------------------- definitions -------------------------------*/
/*---------------------------------------------------------------------------*/

/*------------------------------- object types ------------------------------*/

#define    accPath                206
#define    accPrimPath            232
#define    accWirePath            234
#define    accModNetPath          236
#define    accTermPath            238
#define    accModTermPath         240
#define    accTermModPath         242
#define    accCollapsedNet        304
#define    accVlogSimPath         310
#define    accExpandedPath        312
#define    accSwXlInvisibleNet    314
#define    accAcceleratedNet      316
#define    accAssignmentStat      526
#define    accContAssignStat      527
#define    accNullStat            528
#define    accDelayStat           530
#define    accAssignDelayStat     532
#define    accRtlDelayStat        534
#define    accAssignEventStat     536
#define    accAssignMultiStat     537
#define    accRtlEventStat        538
#define    accRtlMultiStat        539
#define    accGenEventStat        540
#define    accDisableStat         542
#define    accAssignStat          544
#define    accDeassignStat        546
#define    accForceStat           548
#define    accReleaseStat         550
#define    accInitialStat         552
#define    accAlwaysStat          554
#define    accAtEventStat         556
#define    accUnnamedBeginStat    558
#define    accNamedBeginStat      560
#define    accUnnamedForkStat     562
#define    accNamedForkStat       564
#define    accIfStat              566
#define    accCaseStat            568
#define    accCaseZStat           570
#define    accCaseXStat           572
#define    accForeverStat         574
#define    accRepeatStat          576
#define    accWhileStat           578
#define    accForStat             580
#define    accWaitStat            582
#define    accPlusOp              630
#define    accMinusOp             632
#define    accLogNotOp            634
#define    accBitNegOp            636
#define    accRedAndOp            638
#define    accRedNandOp           640
#define    accRedOrOp             642
#define    accRedNorOp            644
#define    accRedXorOp            646
#define    accRedXnorOp           648
#define    accSubOp               650
#define    accDivOp               652
#define    accModOp               654
#define    accEqOp                656
#define    accNeqOp               658
#define    accEqeOp               660
#define    accNeeOp               662
#define    accGtOp                664
#define    accGeOp                666
#define    accLtOp                668
#define    accLeOp                670
#define    accLshOp               672
#define    accRshOp               674
#define    accAddOp               676
#define    accMultOp              678
#define    accLogAndOp            680
#define    accLogOrOp             682
#define    accBitAndOp            684
#define    accBitOrOp             686
#define    accBitXorOp            688
#define    accBitXnorOp           690
#define    accCondOp              692
#define    accExprList            694
#define    accDupConcat           698
#define    accUdpDefn             700
#define    accSeqUdpDefn          702
#define    accCombUdpDefn         704
#define    accUdpEntry            706
#define    accContAssign          708
#define    accExpNamedPort        710
#define    accAssignDriver        712
#define    accModportDriver       714
#define    accModPathHasIfnone    715
#define    accTwoLimitTchk        716
#define    accTimingModel         718
#define    accMultiSrcInt         720

/*------------------ parameter values for acc_configure() -------------------*/

#define    accSpecitemScope         7
#define    accWarnNestedLoconn      9
#define    accWarnNestedHiconn     10
#define    accMinMultiplier        12
#define    accTypMultiplier        13
#define    accMaxMultiplier        14
#define    accAttrDelimStr         15
#define    accDelayCount           16
#define    accDelayArrays          18
#define    accUserErrorString      20
#define    accTwoLimitChecks       21
#define    accEnableUdpDefn        22
#define    accSplitSetuphold       23
#define    accSplitSetupHold       23
#define    accBehavDrivers         24
#define    accReturnExpPortNames   25
#define    accShowContAssignLoads  26
#define    accNoUnExpPortsErrors   27

/*------------ values for type field in t_setval_value structure ------------*/

#define accCompactVal               9
#define accTimeVal                 11

/*----------- values for vc_reason field in t_vc_record structure -----------*/

#define compact_value_change       11

/*------------------------ vcl flag mask definitions ------------------------*/

#define vcl_strength_flag           1
#define vcl_verilog_flag            2
#define vcl_veritime_flag           4
#define vcl_compact_flag            8

/*------------------------------ product types ------------------------------*/

#define accVerilog                  1
#define accVeritime                 2
#define accVerifault                3

/*--------------------- includes for the time callbacks ---------------------*/

#define reason_begin_of_simtime     1
#define reason_end_of_simtime       2


/*----------------- include information for stability checks ----------------*/

#define accTaskFuncStable                 0x0001
#define accSystfStable                    0x0002
#define accPrimStable                     0x0004
#define accContAssignStable               0x0008
#define accBehavStable                    0x0010
#define accNetRegVarStable                0x0020
#define acc_taskfunc_stable               accTaskFuncStable
#define acc_systf_stable                  accSystfStable
#define acc_primitive_stable              accPrimStable
#define acc_contassign_stable             accContAssignStable
#define acc_behav_stable                  accBehavStable
#define acc_netreg_stable                 accNetRegVarStable
#define acc_setstabflags_m(_flags,_pos)   (_flags |= _pos)
#define acc_clearstabflags_m(_flags,_pos) (_flags &= ~_pos)
#define acc_isstabflags_m(_flags,_pos)    (_flags & _pos)

/*---------------------------------------------------------------------------*/
/*-------------------------- routine declarations ---------------------------*/
/*---------------------------------------------------------------------------*/

#if defined(__STDC__) || defined(__cplusplus)

#ifndef PROTO_PARAMS
#define PROTO_PARAMS(params) params
#define DEFINED_PROTO_PARAMS
#endif
#ifndef EXTERN
#define EXTERN
#define DEFINED_EXTERN
#endif

#else

#ifndef PROTO_PARAMS
#define PROTO_PARAMS(params) (/* nothing */)
#define DEFINED_PROTO_PARAMS
#endif
#ifndef EXTERN
#define EXTERN extern
#define DEFINED_EXTERN
#endif

#endif /* __STDC__ */

EXTERN char   *acc_cond_fetch_fullname PROTO_PARAMS((handle object_handle));
EXTERN char   *acc_cond_fetch_name PROTO_PARAMS((handle object_handle));
EXTERN char   *acc_cond_fetch_type_str PROTO_PARAMS((int type));
EXTERN int     acc_fetch_attribute_int PROTO_PARAMS((handle object, ...));
EXTERN double  acc_fetch_attribute_real PROTO_PARAMS((handle object, ...));
EXTERN char   *acc_fetch_attribute_str PROTO_PARAMS((handle object, ...));
EXTERN int     acc_fetch_paramval_int PROTO_PARAMS((handle param));
EXTERN double  acc_fetch_paramval_real PROTO_PARAMS((handle param));
EXTERN char   *acc_fetch_paramval_str PROTO_PARAMS((handle param));
EXTERN handle  acc_handle_by_location PROTO_PARAMS((p_location location_p, handle scope));
EXTERN handle  acc_handle_defn PROTO_PARAMS((handle prim));
EXTERN bool    acc_has_multi_drivers PROTO_PARAMS((handle object));
EXTERN handle  acc_next_object PROTO_PARAMS(( handle scope, handle object));
EXTERN handle  acc_next_table_entry PROTO_PARAMS((handle defn, handle entry));
EXTERN handle  acc_next_topudp PROTO_PARAMS((handle defn));


#ifdef DEFINED_PROTO_PARAMS
#undef DEFINED_PROTO_PARAMS
#undef PROTO_PARAMS
#endif

#ifdef DEFINED_EXTERN
#undef DEFINED_EXTERN
#undef EXTERN
#endif

/*---------------------------------------------------------------------------*/
/*---------------------------- macro definitions ----------------------------*/
/*---------------------------------------------------------------------------*/

/* test whether strength information is requested for vcl */
#define vcl_setstr_m(flags_) ( flags_ |= vcl_strength_flag )
#define vcl_clearstr_m(flags_) ( flags_ &= ~vcl_strength_flag )
#define vcl_isstr_m(flags_) ( flags_ & vcl_strength_flag )

/* test whether Verilog information is requested for vcl */
#define vcl_setvl_m(flags_) ( flags_ |= vcl_verilog_flag )
#define vcl_clearvl_m(flags_) ( flags_ &= ~vcl_verilog_flag )
#define vcl_isvl_m(flags_) ( flags_ & vcl_verilog_flag )

/* test whether Veritime information is requested for vcl */
#define vcl_setvt_m(flags_) ( flags_ |= vcl_veritime_flag )
#define vcl_clearvt_m(flags_) ( flags_ &= ~vcl_veritime_flag )
#define vcl_isvt_m(flags_) ( flags_ & vcl_veritime_flag )

/* test whether vcl trigger is compact or normal */
#define vcl_setcompact_m(flags_) ( flags_ |= vcl_compact_flag )
#define vcl_clearcompact_m(flags_) ( flags_ &= ~vcl_compact_flag )
#define vcl_iscompact_m(flags_) ( flags_ & vcl_compact_flag )



#endif /* VXL_ACC_USER_H */
