/*
 * |-----------------------------------------------------------------------|
 * |                                                                       |
 * |   Copyright Cadence Design Systems, Inc. 1985, 1988.                  |
 * |     All Rights Reserved.       Licensed Software.                     |
 * |                                                                       |
 * |                                                                       |
 * | THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CADENCE DESIGN SYSTEMS |
 * | The copyright notice above does not evidence any actual or intended   |
 * | publication of such source code.                                      |
 * |                                                                       |
 * |-----------------------------------------------------------------------|
 */

/*
 * |-------------------------------------------------------------|
 * |                                                             |
 * | PROPRIETARY INFORMATION, PROPERTY OF CADENCE DESIGN SYSTEMS |
 * |                                                             |
 * |-------------------------------------------------------------|
 */


#ifndef VXL_VERIUSER_H
#define VXL_VERIUSER_H

/*---------------------------------------------------------------------------*/
/*------------------------------- definitions -------------------------------*/
/*---------------------------------------------------------------------------*/

/*-------------- values for reason parameter to misctf routines -------------*/

#define reason_diverge           12
#define REASON_DIVERGE            reason_diverge
#define reason_converge          13
#define REASON_CONVERGE           reason_converge
#define reason_vld_interact      14
#define REASON_VLD_INTERACT       reason_vld_interact
#define reason_snapsave          23
#define reason_endofsnapsave     24
#define reason_snaprestart       25
#define reason_endofsnaprestart  26

/*------------- values for component 'type' in tfcell structure -------------*/
#define usertask                  1
#define USERTASK                  usertask
#define userfunction              2
#define USERFUNCTION              userfunction
#define userrealfunction          3
#define USERREALFUNCTION          userrealfunction

/*---------------------------------------------------------------------------*/
/*----------------------- global variable definitions -----------------------*/
/*---------------------------------------------------------------------------*/

extern char *tf_error_message;

/*---------------------------------------------------------------------------*/
/*-------------------------- structure definitions --------------------------*/
/*---------------------------------------------------------------------------*/

/*----------------- structure used for the veriusertfs array ----------------*/
typedef struct t_tfcell
{
    short type;
    short data;
    int (*checktf)();
    int (*sizetf)();
    int (*calltf)();
    int (*misctf)();
    char *tfname;
    int forwref;
    char *tfveritool;
    char *tferrmessage;
    int hash;
    struct t_tfcell *left_p;
    struct t_tfcell *right_p;
    char *namecell_p;
    int warning_printed;
} s_tfcell, *p_tfcell;

/*---------------------------------------------------------------------------*/
/*--------------------------- routine definitions ---------------------------*/
/*---------------------------------------------------------------------------*/

#if defined(__STDC__) || defined(__cplusplus)

#ifndef PROTO_PARAMS
#define PROTO_PARAMS(params) params
#define DEFINED_PROTO_PARAMS
#endif
#ifndef EXTERN
#define EXTERN
#define DEFINED_EXTERN
#endif

#else

#ifndef PROTO_PARAMS
#define PROTO_PARAMS(params) (/* nothing */)
#define DEFINED_PROTO_PARAMS
#endif
#ifndef EXTERN
#define EXTERN extern
#define DEFINED_EXTERN
#endif

#endif /* __STDC__ */

EXTERN char        *tf_getstrength PROTO_PARAMS((char *value_cell));
EXTERN char        *tf_igettflist PROTO_PARAMS((char *inst));
EXTERN int          tf_isettflist PROTO_PARAMS((char *tflist, char *inst));
EXTERN int          tf_settflist PROTO_PARAMS((char *tflist));


#ifdef DEFINED_PROTO_PARAMS
#undef DEFINED_PROTO_PARAMS
#undef  PROTO_PARAMS
#endif

#ifdef DEFINED_EXTERN
#undef DEFINED_EXTERN
#undef EXTERN
#endif

/***********************************************/


#endif /* VXL_VERIUSER_H */
