-- ALARM_SM_2.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

entity alarm_sm_2 is 
port( COMPARE_IN,TOGGLE_ON : in STD_LOGIC;
      CLOCK                : in STD_LOGIC;
      RING                 : out STD_LOGIC);
end;

architecture BEHAVIOR of alarm_sm_2 is 

    type state_type is (IDLE, ACTIVATE);
    signal CURRENT_STATE, NEXT_STATE: state_type;

begin
    COMBIN: process(CURRENT_STATE,COMPARE_IN,TOGGLE_ON)
    begin
	case CURRENT_STATE is 
	    when IDLE =>
		RING <= '0';
		    if (COMPARE_IN and TOGGLE_ON) = '1' then
			NEXT_STATE <= ACTIVATE;
		    else
			NEXT_STATE <= IDLE;
		    end if;

	    when ACTIVATE =>
		RING <= '1';
	   	    if TOGGLE_ON = '0' then
			NEXT_STATE <= IDLE;
		    else
			NEXT_STATE <= ACTIVATE;
		    end if;
	end case;
    end process;

    SYNCH: process
    begin
	wait until CLOCK' event and CLOCK = '1';
	    CURRENT_STATE <= NEXT_STATE;
	end process;

end BEHAVIOR;
