-- COMPARATOR.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

entity comparator is
port ( ALARM_HRS,CLOCK_HRS      : in  INTEGER range 1 to 12; 
       ALARM_MINS,CLOCK_MINS    : in  INTEGER range 0 to 59;
       ALARM_AM_PM, CLOCK_AM_PM : in STD_LOGIC;
       RINGER                   : out STD_LOGIC);
end;

architecture BEHAVIOR of comparator is
begin

   COMP:process( ALARM_HRS,CLOCK_HRS,ALARM_MINS,CLOCK_MINS,
		 ALARM_AM_PM,CLOCK_AM_PM)
   begin
	RINGER <= '0';
	if ((ALARM_HRS = CLOCK_HRS) and (ALARM_MINS = CLOCK_MINS) and 
            (ALARM_AM_PM = CLOCK_AM_PM))  then
	   	 RINGER <= '1';
	end if;

   end process;

end BEHAVIOR;
           
