-- MUX.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;


entity mux is
port( ALARM_HRS,TIME_HRS     : in  INTEGER range 1 to 12;
      ALARM_MINS,TIME_MINS   : in  INTEGER range 0 to 59; 
      ALARM_AM_PM,TIME_AM_PM : in STD_LOGIC;
      ALARM_SET              : in STD_LOGIC;
      OUTBUS                 : out UNSIGNED(10 downto 0));
end;

architecture BEHAVIOR of mux is
begin
    process( ALARM_SET,ALARM_HRS,TIME_HRS,ALARM_MINS,
	     TIME_MINS,ALARM_AM_PM,TIME_AM_PM)
	
        variable temp : UNSIGNED(10 downto 0);
	begin
   	    if (ALARM_SET = '1') then
	        temp := conv_unsigned(ALARM_HRS,4)
			&conv_unsigned(ALARM_MINS,6)&ALARM_AM_PM;
	    else 
	 	temp := conv_unsigned(TIME_HRS,4)
			&conv_unsigned(TIME_MINS,6)&TIME_AM_PM;
     	    end if;
		OUTBUS <= temp;
	end process;
end;
