-- ALIGN_STR.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- This example contains two 8 bit registers, two 8 bit counters, and a 8 bit
-- bidirectional bus.  The counters are tri-states to the bidirectional bus.
--      align_str.vhd 5/24/95
--

library IEEE;
use IEEE.std_logic_1164.all;

entity align_str is
    port( X : inout std_logic_vector(7 downto 0);
          CLK : in std_logic;
          CLR_C : in std_logic;
          CLR_D : in std_logic;
          EN_C : in std_logic;
          EN_D : in std_logic;
          MUX_SEL : in std_logic_vector(1 downto 0);
          SEL : in std_logic );
end align_str;

architecture BEHAVIORAL of align_str is
    component count8
       port(CLOCK, CLEAR, ENABLE : in std_logic;
            COUT : out std_logic_vector(7 downto 0));
    end component;

    signal A : std_logic_vector(7 downto 0);
    signal B : std_logic_vector(7 downto 0);
    signal C : std_logic_vector(7 downto 0);
    signal D : std_logic_vector(7 downto 0);
    signal X_I : std_logic_vector(7 downto 0);

begin
    countC : count8 port map(CLK, CLR_C, EN_C, C);
    countD : count8 port map(CLK, CLR_D, EN_D, D);
    X <= X_I when (SEL = '0') else "ZZZZZZZZ";
    
    MUX_SEL_A : process (MUX_SEL, A)
    begin
       if (MUX_SEL = "00") then
           X_I <= A;
       else
           X_I <= "ZZZZZZZZ";
       end if;
    end process;

    MUX_SEL_B : process (MUX_SEL, B)
    begin
       if (MUX_SEL = "01") then
           X_I <= B;
       else
           X_I <= "ZZZZZZZZ";
       end if;
    end process;

    MUX_SEL_C : process (MUX_SEL, C)
    begin
       if (MUX_SEL = "10") then
           X_I <= C;
       else
           X_I <= "ZZZZZZZZ";
       end if;
    end process;

    MUX_SEL_D : process (MUX_SEL, D)
    begin
       if (MUX_SEL = "11") then
           X_I <= D;
       else
           X_I <= "ZZZZZZZZ";
       end if;
    end process;

    ADD_A_B_REG: process (CLK, X)
    begin
        if  (CLK'event and CLK = '1') then
            A <= X;
            B <= X;
        end if;
    end process; -- End ADD_A_REG

end BEHAVIORAL;
