-- COUNT8.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- 8-bit Counter with Enable and Clear
-- June 1995

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity count8 is
   port (CLOCK, CLEAR, ENABLE : in std_logic;
         COUT : out std_logic_vector(7 downto 0));
end count8;

architecture COUNT8_BEH of count8 is
   signal QOUT : std_logic_vector(7 downto 0);
begin
   process(CLEAR, CLOCK, ENABLE)
   begin
      if (CLEAR = '1') then
         QOUT <= "00000000";
      elsif (CLOCK'event and CLOCK='1') then
         if (ENABLE = '1') then
            QOUT <= QOUT + 1;
         end if;
      end if;
   end process;
   COUT <= QOUT;

end COUNT8_BEH;
