-------------------------------------------------- 
-- VHDL Model for a 16-bit Barrel Shifter   	--
-- 		barrel_org.vhd 			--
-- !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! --
-- THIS EXAMPLE IS FOR COMPARISON ONLY          --
-- June 1995                                    --
-- USE barrel.vhd                               --
--------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;

entity barrel_org is
   port (S:	in    STD_LOGIC_VECTOR (3 downto 0);
         A_P:	in    STD_LOGIC_VECTOR (15 downto 0);
         B_P:	out   STD_LOGIC_VECTOR (15 downto 0));
end barrel_org;

architecture RTL of barrel_org is

begin 
    SHIFT: process (S, A_P)
    begin
        case S is
            when "0000" => 
	        B_P               <= A_P;

	    when "0001" =>
	        B_P(14 downto 0)  <= A_P(15 downto 1);
	        B_P(15) 	  <= A_P(0);

	    when "0010" =>
	   	B_P(13 downto 0)  <= A_P(15 downto 2);
	        B_P(15 downto 14) <= A_P(1 downto 0);

            when "0011" =>
	        B_P(12 downto 0)  <= A_P(15 downto 3);
	        B_P(15 downto 13) <= A_P(2 downto 0);

	    when "0100" =>
		B_P(11 downto 0)  <= A_P(15 downto 4);
		B_P(15 downto 12) <= A_P(3 downto 0);

	    when "0101" =>
		B_P(10 downto 0)  <= A_P(15 downto 5);
		B_P(15 downto 11) <= A_P(4 downto 0);

	    when "0110" =>
		B_P(9 downto 0)   <= A_P(15 downto 6);
		B_P(15 downto 10) <= A_P(5 downto 0);

	    when "0111" =>
		B_P(8 downto 0)   <= A_P(15 downto 7);
		B_P(15 downto 9)  <= A_P(6 downto 0);

	    when "1000" =>
		B_P(7 downto 0)   <= A_P(15 downto 8);
		B_P(15 downto 8)  <= A_P(7 downto 0);

	    when "1001" =>
		B_P(6 downto 0)  <= A_P(15 downto 9);
		B_P(15 downto 7) <= A_P(8 downto 0);

	    when "1010" =>
		B_P(5 downto 0)  <= A_P(15 downto 10);
		B_P(15 downto 6) <= A_P(9 downto 0);

	    when "1011" =>
		B_P(4 downto 0)  <= A_P(15 downto 11);
		B_P(15 downto 5) <= A_P(10 downto 0);

	    when "1100" =>
		B_P(3 downto 0)  <= A_P(15 downto 12);
		B_P(15 downto 4) <= A_P(11 downto 0);

	    when "1101" =>
		B_P(2 downto 0)  <= A_P(15 downto 13);
		B_P(15 downto 3) <= A_P(12 downto 0);

	    when "1110" =>
		B_P(1 downto 0)  <= A_P(15 downto 14);
		B_P(15 downto 2) <= A_P(13 downto 0);

	    when "1111" =>
		B_P(0)  	 <= A_P(15);
		B_P(15 downto 1) <= A_P(14 downto 0);

	    when others =>
		B_P		 <= A_P;
	    end case;
    end process; -- End SHIFT   

end RTL;

