-- BIDI_REG.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity bidi_reg is
    port (SIGA: inout STD_LOGIC_VECTOR (3 downto 0);
          LOADA, CLOCK1, CLOCK2, RST: in STD_LOGIC);
end bidi_reg;

architecture BEHAV of bidi_reg is
    component reg4
        port (INX: in STD_LOGIC_VECTOR (3 downto 0);
	      LOAD, CLOCK, RESET: in STD_LOGIC;
	      OUTX: buffer STD_LOGIC_VECTOR (3 downto 0));
    end component;

    component OFDT_F
        port (O: out STD_LOGIC;
	      D: in STD_LOGIC;
	      C: in STD_LOGIC;
	      T: in STD_LOGIC);
    end component;

    component IBUF
        port (O: out STD_LOGIC;
	      I: in STD_LOGIC);
    end component;

    signal INA, OUTA: STD_LOGIC_VECTOR (3 downto 0);

begin
    U5: reg4 port map (INX=>INA,LOAD=>LOADA,CLOCK=>CLOCK1,RESET=>RST,
	               OUTX=> OUTA);
    U0: OFDT_F port map (O=>SIGA(0),D=>OUTA(0),C=>CLOCK2,T=>LOADA);
    U1: OFDT_F port map (O=>SIGA(1),D=>OUTA(1),C=>CLOCK2,T=>LOADA);
    U2: OFDT_F port map (O=>SIGA(2),D=>OUTA(2),C=>CLOCK2,T=>LOADA);
    U3: OFDT_F port map (O=>SIGA(3),D=>OUTA(3),C=>CLOCK2,T=>LOADA);
    U4: IBUF port map (O=>INA(0),I=>SIGA(0));	
    U6: IBUF port map (O=>INA(1),I=>SIGA(1));	
    U7: IBUF port map (O=>INA(2),I=>SIGA(2));	
    U8: IBUF port map (O=>INA(3),I=>SIGA(3));	
end BEHAV;		
