------------------------------------------
--	         REG4.VHD		--
-- 4 - BIT Loadable Register		--
------------------------------------------	

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity reg4 is
    port (INX: in STD_LOGIC_VECTOR (3 downto 0);
          LOAD, CLOCK, RESET:  in STD_LOGIC;
          OUTX: buffer STD_LOGIC_VECTOR (3 downto 0));
end reg4;

architecture BEHAV of reg4 is

begin
    LOAD_REG: process (RESET, CLOCK, LOAD, INX)
    begin
        if RESET='1' then
 	    OUTX <= "0000";
 	elsif (CLOCK'event and CLOCK='1') then
	    if (LOAD='1') then 
	        OUTX <= INX;
	    else 
		OUTX <= OUTX;
	    end if;
	end if;
    end process; --End LOAD_REG	

end BEHAV;		
