-- GATE_CLOCK.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity gate_clock is
    port (IN1,IN2,DATA,CLK,LOAD: in STD_LOGIC;
	  OUT1: out STD_LOGIC);
end gate_clock;	

architecture BEHAVIORAL of gate_clock is

signal GATECLK: STD_LOGIC;

begin

GATECLK <= not((IN1 and IN2) and CLK);

    GATE_PR: process (GATECLK,DATA,LOAD) 
    begin
        if (GATECLK'event and GATECLK='1') then
            if (LOAD='1') then
	        OUT1 <= DATA;
	    end if;
	end if;
    end process; --End GATE_PR

end BEHAVIORAL;
