-- RAM16X2.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- Instantiations of 2-rm16x1 Xilinx RAM
-- June 1995

library IEEE;
use IEEE.std_logic_1164.all;

entity RAM16X2 is
   port ( DATA : in STD_LOGIC_VECTOR(1 downto 0);
          ADDR : in STD_LOGIC_VECTOR(3 downto 0);
          WE   : in STD_LOGIC;
          DOUT  : out STD_LOGIC_VECTOR(1 downto 0)
        );
end RAM16X2;

architecture STRUCTURAL_RAM of RAM16X2 is
   component RAM16X1
       port (D, A0, A1, A2, A3, WE : in STD_LOGIC;
             O : out STD_LOGIC
             );
   end component;

begin
   RAM16X1_COMP_1 :  RAM16X1 port map ( D => DATA(1), 
                             A3 => addr(3), A2 => addr(2), A1 => addr(1), A0 => addr(0),  
                             WE => WE,  
                             O => DOUT(1) );
   RAM16X1_COMP_2 :  RAM16X1 port map ( D => DATA(0), 
                             A3 => addr(3), A2 => addr(2), A1 => addr(1), A0 => addr(0),  
                             WE => WE,  
                             O => DOUT(0) );
end STRUCTURAL_RAM;
