/************************************************************************/
/*    									*/
/*  Rev 1.0 Config. (c) 1995 Xilinx Inc. 				*/
/*    									*/
/*  uP Download program, requires an ASCII bit configuration data file. */
/*    									*/
/*  Program source and executeables are not supported.			*/
/*  No guarantees are provided or implied by this program or sources.	*/
/*  Xilinx customers may use this program and sources for configuring   */
/*  Xilinx Parts without royalty.					*/
/*    									*/
/*  This program must be used with the Application circuit given in the */
/*  accompanying note. 							*/
/*    									*/
/*  WARNING THIS PROGRAM'S CONFIGURATION CIRCUIT SHOULD ONLY BE USED    */
/*  WITH THE FOLLOWING PART FAMILIES: XC31xxA, XC4xxx & A, XC52xx	*/
/*    									*/
/*    									*/
/*    									*/
/*    									*/
/* Complied with Borland C++ version 3.0. 				*/
/*    									*/
/************************************************************************/

#include  <stdio.h>
#include  <io.h>
#include  <conio.h>
#include  <string.h>

#define IOPORTADDR 0x300	/* This must be an unused I/O address for    */
				/* the IBM PC. 				     */
				/* Other options are:			     */
				/*					     */
				/*					     */
				/*					     */
				/*					     */

#define MAXSIZEBITS 55000 	/* Number of device configuration data bits. */
				/* Dependent upon actual device used.	     */
				/* See the data book for details.	     */
#define DEVICEFACTOR 900000	/* Waiting factor, this is a device and      */
				/* host machine dependent delay factor.      */
				/* unfortunately we can not use the PC's     */
				/* timers due to them being I/O mapped.	     */
				/* See App Note for further details.	     */

FILE *fp;			/* Pointer to the ASCII config data file.  */

char dataarray[MAXSIZEBITS];	/* Memory array for the config data.       */
char filechar;   		/* ASCII bit value from config data file.  */
unsigned int addr ,addrcount;   /* Misc counters. */


void delay(long loopval)	/* We need to allow time for the device to */
{				/* finish various operations. 		   */
long j,k;
       for (j = 1; j <= loopval; ++j )
	   {
	   k = inportb(IOPORTADDR);

	   /* Users must ensure that their compiler does not   */
	   /* optimise this loop out as the value of k is      */
	   /* never used.   				       */

	   /* This is a loop delay - as we can not use timers  */
	   /* located in I/O space or interrupts, during the   */
	   /* call. 					       */

	   /* This has to allow for the FPGA device size and   */
	   /* CPU, the only way to achieve some CPU timing     */
	   /* independence for the loop period is to use       */
	   /* I/O reads. This gives the loop a fixed timing    */
	   /* overhead, as the I/O is clocked at 8 MHz.	       */
	   /* Note however that some systems can run I/O at    */
	   /* 10 or 12 MHz, through user options.	       */
	   }
}

void ReadConfigFileData(char filename[11])
{
     addr = 0;
     fp = fopen(filename, "r");
     printf("%s", filename);
     while (!feof(fp))
       {
	 fscanf(fp, "%c", &filechar);
	 dataarray[addr] = filechar;
	 ++addr;
	}
     printf(" Length of File read is %u", addr-1, " bytes");
     /* Note that addr is incremented 1 too many times, hence -1 above. */
}

void InitFPGA(long delayval)
{
     outportb(IOPORTADDR, 0x00);	/* Initialise the config memory. */
     outportb(IOPORTADDR, 0xff);	/* both output's required. */

     delay(delayval);   /* Period to allow device to do internal clear. */
			/* This has to be a program loop, as interrupts are */
			/* now switched off, so we can't read the timers.*/
			/* Delayval must be calculated for each device.  */
			/* Alternatively we can assume worst case delay. */
			/* ie for largest device, and then add a margin. */
}

void WriteConfigDataToFPGA(long delayvalue)
{
  addrcount = 0;
  while (addrcount != addr)
     {
	if (dataarray[addrcount] ==  '1') outportb(IOPORTADDR,0xff);
	else outportb(IOPORTADDR,0xfe); /* '0' case selected. */
	/* We assume a valid data bit either ASCII '1' or '0'. */
	/* A default case could be provided for error checking. */
       addrcount++;
     }
  delay(delayvalue);    /* Allow the device time to complete the */
			/* cofiguration. 			 */
}


int main()
{
     printf("\n \n");
     printf(" Started Configuration Process. \n");
     printf(" File data read, now press any key to do download. \n ");

     while (!kbhit());
     ReadConfigFileData("pc_trunc.stp"); /* This file must be ******/
     asm cli;		/* Disable interrupts - disk access will kill   */
			/* the download. 				*/

     InitFPGA(DEVICEFACTOR);	/* Strobe the program line, start       */
				/* device init   			*/

     WriteConfigDataToFPGA(DEVICEFACTOR);  /* Write data to device. */

     asm sti;	        /* Re-enable interrupts, then we can use the PC */
			/* again, otherwise it is locked up. */

     printf("\n Finished %d \n");
     fclose(fp);
     return 0;		/* Main completed OK. */
}
