library IEEE;
use IEEE.std_logic_1164.all;
library metamor;
use metamor.attributes.all;

entity jcounter is
    port (
        clk:					in STD_LOGIC;
        Dout:					buffer STD_LOGIC_VECTOR (7 downto 0)
    );

-- Can use attributes to assign pin locations in Foundation VHDL
    attribute pinnum of Dout:			signal is "p13,14,16,18,19,20,21,22";
end jcounter;

architecture jcounter_arch of jcounter is
begin

process (CLK)
begin
   if CLK'event and CLK='1' then		-- CLK rising edge
      Dout(7 downto 1) <= Dout(6 downto 0);	-- Shift register
      Dout (0) <= not Dout(7);			-- Last bit inverted back into first bit
   end if;
end process;

end jcounter_arch;
