/* ALARM_SM_2.V
 * Xilinx HDL Synthesis Design Guide for FPGAs
 * June 1995 */

module alarm_sm_2 (COMPARE_IN,TOGGLE_ON,CLOCK,RING);
input COMPARE_IN,TOGGLE_ON,CLOCK;
output RING;
reg RING,CURRENT_STATE,NEXT_STATE;

parameter IDLE=0, ACTIVATE=1;
        always @ (CURRENT_STATE or COMPARE_IN or TOGGLE_ON) begin

	case (CURRENT_STATE) // synopsys parallel_case full_case

	   IDLE:        begin
			RING = 0;
			if (COMPARE_IN && TOGGLE_ON) 
				NEXT_STATE = ACTIVATE;
			else
				NEXT_STATE = IDLE;
			end

	  ACTIVATE:     begin
			RING = 1;
			if (!TOGGLE_ON ) 
				NEXT_STATE = IDLE;
			else
				NEXT_STATE = ACTIVATE;
			end 
	endcase
	end

        always @ (posedge CLOCK) begin
	CURRENT_STATE <= NEXT_STATE;
	end 
endmodule 
