/* MUX.V
 * Xilinx HDL Synthesis Design Guide for FPGAs
 * June 1995 */

module
mux(ALARM_HRS,ALARM_MINS,ALARM_AM_PM,TIME_HRS,TIME_MINS,TIME_AM_PM,ALARM_SET, OUTBUS);
input [3:0] ALARM_HRS,TIME_HRS;
input [5:0] ALARM_MINS,TIME_MINS;
input ALARM_AM_PM, TIME_AM_PM,ALARM_SET;
output [10:0] OUTBUS;
reg OUTBUS;

	always @ (ALARM_SET or ALARM_HRS or ALARM_MINS or ALARM_AM_PM or
                  TIME_HRS or TIME_MINS or TIME_AM_PM)  begin
		OUTBUS = 11'bz;
	if (ALARM_SET)
		OUTBUS = ({ALARM_HRS,ALARM_MINS,ALARM_AM_PM});
	else
		OUTBUS = ({TIME_HRS,TIME_MINS,TIME_AM_PM});
	end
endmodule

