/* TIME_BLOCK.V
 * Xilinx HDL Synthesis Design Guide for FPGAs
 * June 1995 */


module time_block ( SET_TIME, HRS, MINS, CLK, CONNECT6, 
     CONNECT7,
     CONNECT8 );
input  SET_TIME, HRS, MINS, CLK;
output [3:0] CONNECT6;
output [5:0] CONNECT7;
output  CONNECT8;
    wire CONNECT3, CONNECT4, CONNECT5;
    time_state_machine U1 ( .TIME_BUTTON(SET_TIME), .HOURS_BUTTON(HRS), 
        .MINUTES_BUTTON(MINS), .CLK(CLK), .SECS(CONNECT5), .HOURS(CONNECT3), 
        .MINS(CONNECT4) );
    time_counter U2 ( .SECS(CONNECT5), .HOURS(CONNECT3), .MINS(CONNECT4), 
        .CLK(CLK), .HOURS_OUT(CONNECT6),
        .MINUTES_OUT(CONNECT7) , 
        .AM_PM_OUT(CONNECT8) );
endmodule

