/*------------------------------------------------ 
-- Verilog Model for a 16-bit Barrel Shifter   	--
-- 		barrel_org.v 			--
-- !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! --
-- THIS EXAMPLE IS FOR COMPARISON ONLY          --
-- USE barrel.v                                 --
----------------------------------------------- */

module barrel_org (S, A_P, B_P);

input [3:0] S;
input [15:0] A_P;
output [15:0] B_P;

reg [15:0] B_P;

    always @ (S or A_P)
    begin 
        case (S)
             4'b0000 : 
		begin
	        B_P        	<= A_P;
		end

	     4'b0001 :
		begin
	        B_P[14:0]  	<= A_P[15:1];
	        B_P[15] 	<= A_P[0];
		end

	     4'b0010 :
		begin
	   	B_P[13:0]  	<= A_P[15:2];
	        B_P[15:14] 	<= A_P[1:0];
		end

             4'b0011 :
		begin
	        B_P[12:0]  	<= A_P[15:3];
	        B_P[15:13] 	<= A_P[2:0];
		end

	     4'b0100 :	
		begin
		B_P[11:0]  	<= A_P[15:4];
		B_P[15:12] 	<= A_P[3:0];
		end

	     4'b0101 :
		begin
		B_P[10:0]  	<= A_P[15:5];
		B_P[15:11] 	<= A_P[4:0];
		end

	     4'b0110 :
		begin
		B_P[9:0]   	<= A_P[15:6];
		B_P[15:10] 	<= A_P[5:0];
		end

	     4'b0111 :
		begin
		B_P[8:0]   	<= A_P[15:7];
		B_P[15:9]  	<= A_P[6:0];
		end

	     4'b1000 :
		begin
		B_P[7:0]   	<= A_P[15:8];
		B_P[15:8]  	<= A_P[7:0];
		end

	     4'b1001 :
		begin
		B_P[6:0]  	<= A_P[15:9];
		B_P[15:7] 	<= A_P[8:0];
		end

	     4'b1010 :
		begin
		B_P[5:0]  	<= A_P[15:10];
		B_P[15:6] 	<= A_P[9:0];
		end

	     4'b1011 :
		begin	
		B_P[4:0]  	<= A_P[15:11];
		B_P[15:5] 	<= A_P[10:0];
		end

	     4'b1100 :
		begin
		B_P[3:0]  	<= A_P[15:12];
		B_P[15:4] 	<= A_P[11:0];
		end

	     4'b1101 :
		begin
		B_P[2:0]  	<= A_P[15:13];
		B_P[15:3] 	<= A_P[12:0];
		end

	     4'b1110 :
		begin
		B_P[1:0]  	<= A_P[15:14];
		B_P[15:2] 	<= A_P[13:0];
		end

	     4'b1111 :
		begin
		B_P[0] 		<= A_P[15];
		B_P[15:1] 	<= A_P[14:0];
		end

	     default :
	    	begin
		B_P		<= A_P;
		end
	 endcase
    end 

endmodule
