/* BND_SCAN.V
 * Xilinx HDL Synthesis Design Guide for FPGAs
 * June 1995
 * Boundary Scan Example */

module bnd_scan (TDI_P, TMS_P, TCK_P,
		 LOAD_P, CLOCK_P, CE_P, RESET_P,
		 DATA_P,
	         TDO_P,
		 COUT_P);

inout 		TDI_P, TMS_P, TCK_P;
input		LOAD_P, CLOCK_P, CE_P, RESET_P;
input  [3:0]	DATA_P;
output 		TDO_P;
output [3:0] 	COUT_P;

BSCAN U1 (.TDO(TDO_P), .TDI(TDI_P), .TMS(TMS_P), .TCK(TCK_P));

TDI U2 (.I(TDI_P));

TCK U3 (.I(TCK_P));

TMS U4 (.I(TMS_P));

TDO U5 (.O(TDO_P));

count4 U6 (.LOAD(LOAD_P), .CLOCK(CLOCK_P), .CE(CE_P), 
	   .RST(RESET_P), .DATA(DATA_P), .COUT(COUT_P));

endmodule
