/* BUFT_EX.V
 * Xilinx HDL Synthesis Design Guide for FPGAs
 * This is an example the shows you how to infer tri-state buffers.
 * June 1995                                                         */

module buft_ex (DATAIN0, DATAIN1, SEL, CLK, DATAOUT) ;
input 	[3:0]	DATAIN0;
input   [3:0]   DATAIN1;
input           SEL;
input           CLK;
output  [3:0]   DATAOUT;

reg     [3:0]   mainline;
reg     [3:0]   DATAOUT;

always @ (SEL or DATAIN0)
    begin
        if (!SEL)
            mainline = DATAIN0;
        else
            mainline = 4'bz;
    end

always @ (SEL or DATAIN1)
    begin
        if (SEL)
            mainline = DATAIN1;
        else
            mainline = 4'bz;
    end

always @ (posedge CLK)
    begin
        DATAOUT = mainline;
    end

endmodule
