/* The XC4000 device registers can perform a asynchronous
   clear or preset but NOT both.  This design was broken
   into two register and then muxed togther.  The CLR has
   precedence over Preset */ 

module clr_pre (CLR, PRE, CLK, QOUT);

input CLR, PRE;
input CLK;
output QOUT;

reg QOUT;
reg PRE_Q, CLR_Q;

/*  Process to choose between CLEAR and PRESET register */
    always @ (CLR or PRE or PRE_Q or CLR_Q) 
    begin
        if (CLR == 1'b0 && PRE == 1'b1) 
            QOUT = PRE_Q;
        else
            QOUT = CLR_Q;
    end 

/* The asynchronous clear register, CLR_Q */
    always @ (posedge CLR or posedge CLK)
    begin
        if (CLR == 1'b1)
            CLR_Q = 1'b0;
        else 
            CLR_Q = 1'b0;
    end 

/* The asynchronous preset register, PRE_Q */
    always @ (posedge PRE or posedge CLK) 
    begin
        if (PRE == 1'b1) 
            PRE_Q = 1'b1;
        else 
            PRE_Q = 1'b0;
    end 

endmodule 
