/* USE_GSR_PRE Example
 * Xilinx HDL Synthesis Design Guide for FPGAs
 * The signal RESET initializes UPCNT using the
 * global STARTUP signal.
 * The singal PRESET initializes DNCNT
 * June 1995 */

module use_gsr_pre ( CLOCK, PRESET, RESET, UPCNT, DNCNT);

input CLOCK, PRESET, RESET;
output [3:0] UPCNT;
output [3:0] DNCNT;

reg [3:0] UPCNT;
reg [3:0] DNCNT;

STARTUP U1 (.GSR(RESET));

always @ (posedge CLOCK) begin
    UPCNT = UPCNT + 1'b1;
end

// To simulate the RESET signal uncomment the lines
// below and comment out the STARTUP and always lines.
// above.
//always @ (posedge CLOCK or posedge RESET) begin
//    if (RESET) begin
//        UPCNT = 4'b0000;
//    end else begin
//        UPCNT = UPCNT + 1'b1;
//    end
//end

// To simulate connect PRESET to RESET
always @ (posedge CLOCK or posedge PRESET) begin
    if (PRESET) begin
	 DNCNT = 4'b1111;
    end else begin
	 DNCNT = DNCNT - 1'b1;
    end
end

endmodule
