/* This is the verilog version that incorporates a RAM and a RPM.
   This is a tutorial example for the floorplanner.
   Thise design will increment throug a RAM.
  
   File: rpm_ram.v
********************************************************************/
module rpm_ram(CLOCK, CLEAR, ENABLE, WE, DATAIN, DATAOUT);
input           CLOCK;
input           CLEAR;
input           ENABLE;
input           WE;
input  [1:0]    DATAIN;
output [1:0]    DATAOUT;

reg    [1:0]    DATAOUT; 
wire   [1:0]    ram_out;
wire   [3:0]    addr_to_ram;

RAM16X2 RAM_COMP(.DATA(DATAIN), .ADDR(addr_to_ram), .WE(WE), .DOUT(ram_out));

count4  INC_TO_RAM(.CLOCK(CLOCK), .CLEAR(CLEAR), .ENABLE(ENABLE), .COUT(addr_to_ram));

always @(posedge CLOCK)
begin
   DATAOUT <= ram_out;
end

endmodule
