/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993 and 1994 by      *
* Cadence Design Systems .                                                    *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

LIBRARY        : Xilinx XC2000 Library  - Rev 2.0 - Mar 1994.
FUNCTION       : D-LATCH WITH SET and RESET.
	       : Instantiated in a higher level FF w/o the global signals
	       : to match the Composer symbol
REFERENCE      : The XNF Simulation Guide Dated Ver. 5.00 08/13/93.
                 
DESIGNER       : Udi Landen
DATE GENERATED : 1st Mar 1994 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/

`delay_mode_path

`timescale  1 ns / 100 ps
`celldefine 
module ldcp_int (q, clr, d, g, gr, pre);

    output   q;
    
    input    clr, d, g, gr, pre;

`protect
    // if not connected, default to 0
    tri0     clr, pre;

    // if not connected, default to 1
    tri1     gr;

    reg  NOTIFY_REG;

	// clear circuitry
	not  NOT1 (CLRB, clr);
	nand NAND1 (RESET, CLRB, gr);

	// used for timing checks
	not  NOT2 (PREB, pre);
	and  AND1 (GR_CLRB_PREB, gr, CLRB, PREB);
	and  AND2 (GR_CLRB, gr, CLRB);

     	U_LD_P_S_R_NO
            INST1 (q, d, g, RESET, pre, NOTIFY_REG);
            
    specify
    
    // Specify path delays
     
	if (!clr && !pre && gr && g)
	    (d +=> q) = (1, 1);

	if (!clr && !pre && gr)
	    (posedge g  => (q +: d))    = (1, 1);

	if (!clr && gr)
	     (posedge pre => (q +: 1'b1)) = (1, 1);

	if (gr)
	    (posedge clr => (q +: 1'b0)) = (1, 1);

	(negedge gr => (q +: 1'b0)) = (1, 1);

	if (g && !clr && !pre)
	    (posedge gr => (q +: d))    = (1, 1);
	  
	if (g && !clr && gr)
	    (negedge pre => (q +: d))    = (1, 1);
	 
	if (g && gr && !pre)
	    (negedge clr => (q +: d))    = (1, 1);

     // Timing Checks
     
	// setup and hold checks between d and the falling edge of g 
	// when gr=1 clr=0 pre=0
	$setuphold(negedge g &&& GR_CLRB_PREB, d, 1, 1, NOTIFY_REG);
     
	// setup and hold checks between the falling edge of pre and the falling edge of g
	// when gr=1 clr=0
	$setuphold(negedge g &&& GR_CLRB_PREB, pre, 1, 1, NOTIFY_REG);
     
	// setup and hold checks between the falling edge of clr and the falling edge of g
	// when gr=1 pre=0
	$setuphold(negedge g &&& GR_CLRB_PREB, clr, 1, 1, NOTIFY_REG);
     
	// setup and hold checks between the rising edge of gr and the falling edge of g
	// when clr=0 pre=0
	$setuphold(negedge g &&& GR_CLRB_PREB, gr, 1, 1, NOTIFY_REG);
     
    // pulse width checks

	// g high time when gr=1 clr=0 pre=0
	$width(posedge g &&& GR_CLRB_PREB, 1, 1, NOTIFY_REG);

	// gr low time
	$width(negedge gr, 1, 1, NOTIFY_REG);

	// clear high time when gr=1
	$width(posedge clr &&& gr, 1, 1, NOTIFY_REG);

	// pre high time when gr=1 clr=0
	$width(posedge pre &&& GR_CLRB, 1, 1, NOTIFY_REG);

   
    endspecify

`endprotect

endmodule
`endcelldefine
    


