
primitive U_LD_N_S_R_NO_I1 (Q, D, G, R, S, NOTI_REG); 

    output Q; 
    input  D,               // DATA
           G,               // CLOCK
           R,               // CLEAR ACTIVE LOW
           S,               // SET ACTIVE LOW
           NOTI_REG;        // NOTIFY_REG

`protect

    reg    Q;                               

// FUNCTION : NEGATIVE LEVEL SENSITIVE D-TYPE LATCH WITH ACTIVE HIGH
//            ASYNCHRONOUS SET AND RESET.  ( Q OUTPUT UDP ).

// Initialize the output pin Q to logical vlaue 1
`ifdef SYNTH
`else
initial
     Q=1'b1;
`endif

   table
     //  D       G      R     S    NOTI_REG       : Qt  :   Qt+1
                                  
         *       1      0     0     ?             :  ?  :    -   ;
                                  
         ?       ?      1     0     ?             :  ?  :    0   ; // asynchro clear
     
         ?       ?      ?     1     ?             :  ?  :    1   ; 
                             
         ?      (?1)    0     0     ?             :  ?  :    -   ;
         ?      (0x)    0     0     ?             :  ?  :    -   ;
                                  
         0      (x0)    0     0     ?             :  0  :    0   ;
         1      (x0)    0     0     ?             :  1  :    1   ;
         0      (1x)    0     0     ?             :  ?  :    0   ;
         1      (1x)    0     0     ?             :  ?  :    1   ;
                                  
        (?0)     0      0     0     ?             :  ?  :    0   ;
        (?1)     0      0     0     ?             :  ?  :    1   ; 
         0      (10)    0     0     ?             :  ?  :    0   ;
         1      (10)    0     0     ?             :  ?  :    1   ; 
                                  
         ?       ?      x     0     ?             :  0  :    0   ; // Reducing pessimism.
         0      (?0)    x     0     ?             :  ?  :    0   ; // Reducing pessimism.
        (?0)     0      x     0     ?             :  ?  :    0   ; // Reducing pessimism.
     
         ?       ?      0     x     ?             :  1  :    1   ; // Reducing pessimism.
         1      (?0)    0     x     ?             :  ?  :    1   ; // Reducing pessimism.
        (?1)     1      0     x     ?             :  ?  :    1   ; // Reducing pessimism.
                                  
         ?       1     (?0)   0     ?             :  ?  :    -   ;   // ignore edge on clear
         0       0     (?0)   0     ?             :  ?  :    0   ;   // pessimism .
         1       0     (?0)   0     ?             :  ?  :    1   ;  

                                  
         ?       1      0    (?0)   ?             :  ?  :    -   ;   // ignore edge on set
         0       0      0    (?0)   ?             :  ?  :    0   ;   // pessimism .
         1       0      0    (?0)   ?             :  ?  :    1   ;  

        (?1)     x      0     0     ?             :  1  :    1   ; // Reducing pessimism.
        (?0)     x      0     0     ?             :  0  :    0   ; // Reducing pessimism.
                                  
         ?       ?      ?     ?     *             :  ?  :    x   ;

   endtable

`endprotect

endprimitive
