/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993 and 1994 by      *
* Cadence Design Systems .                                                    *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

LIBRARY        : Xilinx XC4000 Library  - Rev 2.0 - Mar 1994.
FUNCTION       : D-LATCH WITH GLOBAL RESET (gsr).
REFERENCE      : The XNF Simulation Guide Dated Ver. 5.00 08/13/93.
                 
DESIGNER       : Udi Landen
DATE GENERATED : 1st Mar 1994 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/

`delay_mode_path

`timescale  1 ns / 100 ps
`celldefine 
module ildi1 (q, d, g, gsr);

    parameter size = 1;
    
    output   q;
    
    input    d, g, gsr;
    
`protect

    // if not connected, default to 0
`ifdef SYNTH
`else
    tri0 gsr;
`endif

    reg  NOTIFY_REG;
  
  
	// use a LATCH UDP that is reset to 1 on simulation time 0
	U_LD_N_S_R_NO_I1
            INST1 (q, d, g, 1'b0, gsr, NOTIFY_REG);
            
    specify
    
     // Specify path delays
     
	// d->q delay
	if (!gsr && !g)
	    (d +=> q) = (1, 1);

	if (!gsr)
	    (posedge g  => (q +: d))    = (1, 1);
  
	(posedge gsr => (q +: 1'b1)) = (1, 1);

      
     // Timing Checks
     
        // setup and hold checks between d and the rising edge of g 
        // when gsr=0
	$setuphold(posedge g &&& ~gsr, d, 1, 1, NOTIFY_REG);

        // setup and hold checks between the falling edge of gsr and the rising edge of g
        $setuphold(posedge g &&& ~gsr, gsr, 1, 1, NOTIFY_REG);

    // pulse width checks

	// g high and low time when gsr=0
	$width(posedge g &&& ~gsr, 1, 1, NOTIFY_REG);
	$width(negedge g &&& ~gsr, 1, 1, NOTIFY_REG); 

	// gsr high time
	$width(posedge gsr, 1, 1, NOTIFY_REG);

   
    endspecify

`endprotect

endmodule
`endcelldefine
    


