/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993 and 1994 by      *
* Cadence Design Systems .                                                    *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

LIBRARY        : Xilinx XC4000E Library
FUNCTION       : 32x1 Static RAM with synchronous write capability
REFERENCE      : Xilinx Simulation Guide
                 
DESIGNER       : Sanjeev Aggarwal
DATE GENERATED : July 28, 1995

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

HISTORY:
	2/9/96 - Dori 
		For PCR 169119, change wclk hold limit from 1 to -1.
	3/6/96 - Dori
		Perform timing check conditionally, based upon the 
		Write Enable (we) signal.

*/

`delay_mode_path

`timescale  1 ns / 100 ps 
`celldefine
module ram32x1s (o, a0, a1, a2, a3, a4, d, wclk, we);

    parameter size = 1,
              init = 0;
    
    output   o;
    
    input    a0, a1, a2, a3, a4, d, wclk, we;

`protect

    reg  VIOLATION;
    reg  mem [0:31];
    wire [4:0] adr;
    wire din, wen;
   
    reg  [5:0] count;

    buf b1 (din, d);
    buf b2 (wen,we);
    buf b3 (adr[4],a4);
    buf b4 (adr[3],a3);
    buf b5 (adr[2],a2);
    buf b6 (adr[1],a1);
    buf b7 (adr[0],a0);
    buf b8 (o, dout);

    buf (dout, mem[adr]);

//    initial
//    begin
//        for(count = 0; count < 32; count = count + 1)
//            mem[count] = init;
//    end
 
    always @(posedge wclk)
    begin
        if(we == 1'b1)
            mem[adr] = din;
    end

    always @ (VIOLATION)
        mem[adr] = 1'bx;

    specify
    
`ifdef SYNTH    
    specparam Area = 1; 
`endif   
    
	// Specify path delays

	if (we)
	    (wclk => o) = (1, 1);

	(a4 => o) = (1, 1);
	(a3 => o) = (1, 1);
	(a2 => o) = (1, 1);
	(a1 => o) = (1, 1);
	(a0 => o) = (1, 1);


	// Timing Checks

        // setup and hold checks between we and the rising edge of wclk
	$setuphold(posedge wclk, we, 1, -1, VIOLATION);

        // setup and hold checks between d and the rising edge of wclk
	$setuphold(posedge wclk &&& we, d, 1, -1, VIOLATION);
 
        // setup and hold checks between a0 and the rising edge of wclk
	$setuphold(posedge wclk &&& we, a0, 1, -1, VIOLATION);
 
        // setup and hold checks between a1 and the rising edge of wclk
	$setuphold(posedge wclk &&& we, a1, 1, -1, VIOLATION);
 
        // setup and hold checks between a2 and the rising edge of wclk
	$setuphold(posedge wclk &&& we, a2, 1, -1, VIOLATION);
 
        // setup and hold checks between a3 and the rising edge of wclk
	$setuphold(posedge wclk &&& we, a3, 1, -1, VIOLATION);
 
        // setup and hold checks between a4 and the rising edge of wclk
	$setuphold(posedge wclk &&& we, a4, 1, -1, VIOLATION);
 
 
    // pulse width checks
 
        // wclk high time
	$width(posedge wclk, 1, 1, VIOLATION);
	$width(negedge wclk, 1, 1, VIOLATION);
 
    endspecify

`endprotect

endmodule
`endcelldefine

