/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993 and 1994 by      *
* Cadence Design Systems .                                                    *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

LIBRARY        : Xilinx XC4000 Library  - Rev 2.0 - Mar 1994.
FUNCTION       : D-FLIP-FLOP
REFERENCE      : The XNF Simulation Guide Dated Ver. 5.00 08/13/93.
                 
DESIGNER       : Udi Landen
DATE GENERATED : 1st Mar 1994 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/

`delay_mode_path

`timescale  1 ns / 100 ps 
`celldefine     

module fdce (q, c, ce, clr, d, gr);

    parameter size = 1;
    
    output   q;
    
    input    c, ce, clr, d, gr;

`protect

    // if not connected, default to 0
    tri0     clr, gr;

    // if not connected, default to 1
    tri1     ce;

    reg  NOTIFY_REG;
    reg  PWR_UP_RST;
    
	// clear circuitry
	or  OR1 (RESET, clr, gr);

	// clock enable circuitry
	U_MUX_2_1 
	    INST1 (D_int, Q_int, d, ce);

	// use a FF UDP that is reset to 0 on simulation time 0
	U_FD_P_R_S_NO_I0
	    INST2 (Q_int, D_int, c, RESET, 1'b0, NOTIFY_REG, PWR_UP_RST);
     
	buf BUFFER1 (q, Q_int);

	// Additional logic added for Timing Checks
	not NOT1 (RESETB, RESET);
	and AND2 (RESETB_CE, RESETB, ce);
    
	xor XOR1 (D_NEQ_Q, d, q);
	and AND3 (D_NEQ_Q_RESETB, RESETB, D_NEQ_Q);

    initial
        PWR_UP_RST = 0;

    specify

    // Specify path delays

	// d->q delay on posedge of clock
	if (!clr && !gr && ce)
	    (posedge c => (q +: d)) = (1, 1);

	// clear FF with clr=1, q->0 delay
	(posedge clr => (q +: 1'b0)) = (1, 1);

	// clear FF with gr=1,  q->0 delay
	(posedge gr => (q +: 1'b0)) = (1, 1);
  
    // Timing Checks
 
	// setup and hold checks between d and the rising edge of clock 
	// when gr=0 clr=0 ce=1
	$setuphold(posedge c &&& RESETB_CE, d, 1, 1, NOTIFY_REG);


	// setup and hold checks between ce and the rising edge of clock 
	// when gr=0 clr=0 and d!=q
	$setuphold(posedge c &&& D_NEQ_Q_RESETB, ce, 1, 1, NOTIFY_REG);

	// setup and hold checks between the falling edge of clr and the rising edge of clock
	// when gr=0 ce=1
	$setuphold(posedge c &&& RESETB_CE, clr, 1, 1, NOTIFY_REG);

	// setup and hold checks between the falling edge of gr and the rising edge of clock
	// when clr=0 ce=1
	$setuphold(posedge c &&& RESETB_CE, gr, 1, 1, NOTIFY_REG);
 
    // pulse width checks

	// clock high time when gr=0 clr=0
	$width(posedge c &&& RESETB, 1, 1, NOTIFY_REG);

	// clock low time when gr=0 clr=0
	$width(negedge c &&& RESETB, 1, 1, NOTIFY_REG);
 
	// gr high time
	$width(posedge gr, 1, 1, NOTIFY_REG);

	// clr high time
	$width(posedge clr, 1, 1, NOTIFY_REG);

    endspecify

`endprotect

`ifdef XBLOX
initial begin
	$sy_xilinx_sym (3,"DFF,INIT=R,SCHNM=fdce,LIBVER=2.0.0");
end
`endif

endmodule

`endcelldefine
                                                                                                                                                 
