/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993 and 1994 by      *
* Cadence Design Systems .                                                    *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

LIBRARY        : Xilinx XC4000 Library  - Rev 2.0 - Mar 1994.
FUNCTION       : Input D-FLIP-FLOP in the IOB
REFERENCE      : The XNF Simulation Guide Dated Ver. 5.00 08/13/93.
                 
DESIGNER       : Udi Landen
DATE GENERATED : 1st Mar 1994 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

HISTORY        : 4/5/95 - Dori
                 Changed comment to say that FF UDP is reset to 1,
                 not 0, on simulation time 0.

*/
       
`delay_mode_path

`timescale  1 ns / 100 ps 
`celldefine     
module ofdi (q, c, d, gr, gts);

    parameter size = 1;
    
    output   q;

    input    c, d, gr, gts;

`protect

`ifdef SYNTH
`else
    tri0 gr, gts;
`endif

    reg  NOTIFY_REG;
    reg  PWR_UP_RST;
    
	// use a FF UDP that is reset to 1 on simulation time 0
	U_FD_P_R_S_NO_I1
	    INST1 (Q_int, d, c, 1'b0, gr, NOTIFY_REG, PWR_UP_RST);

	bufif0 BUFFER1 (q, Q_int, gts);
 
    initial
        PWR_UP_RST = 0;

    specify

    // Specify path delays

	// d->q delay on posedge of clock
	if (!gts && !gr)
	    (posedge c => (q +: d)) = (1, 1);

	// preset FF,  q->1 delay
	if (!gts)
	    (posedge gr => (q +: 1'b1)) = (1, 1);
      
	// gts delay
	(gts => q) = (1, 1, 0);
      
    // Timing Checks
     
	// setup and hold checks between d and the rising edge of clock when gr=0
	$setuphold(posedge c &&& ~gr, d, 1, 1, NOTIFY_REG);
 
	// setup and hold checks between the falling edge of gr and the rising edge of clock
	$setuphold(posedge c &&& ~gr, gr, 1, 1, NOTIFY_REG);
 
    // pulse width checks

	// clock high time when gr=0
	$width(posedge c &&& ~gr, 1, 1, NOTIFY_REG);

	// clock low time when gr=0
	$width(negedge c &&& ~gr, 1, 1, NOTIFY_REG); 

	// gr high time
	$width(posedge gr, 1, 1, NOTIFY_REG);

    endspecify

`endprotect

endmodule
`endcelldefine


