/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993 and 1994 by      *
* Cadence Design Systems .                                                    *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

LIBRARY        : Xilinx XC5200 Library
FUNCTION       : Oscillator
REFERENCE      : Xilinx Simulation Guide Ver. 5.10-11/30/94.
                 
DESIGNER       : Sanjeev Aggarwal
DATE GENERATED : August 31, 1995

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/

`timescale  1 ns / 10 ps 
`celldefine     
module osc52 (osc1, osc2, c);

    parameter size = 1,
              osc = "internal",
              divide1_by = 4,
              divide2_by = 2;

    output osc1, osc2;

    input  c;

`protect
    
    reg     osc1_int, first_edge1,
            osc2_int, first_edge2;
    real    int_clk;
    integer count1, count2;

    buf b1 (osc1, osc1_int);
    buf b2 (osc2, osc2_int);

    initial
    begin
        int_clk     = 31.25;        // 16 MHz

        osc1_int    = 0;
        osc2_int    = 0;

        first_edge1 = 0;
        first_edge2 = 0;
        count1      = 0;
        count2      = 0;
    end

    always
    begin
        if(osc == "user_clk")
        begin
            @(posedge c);

            if (divide1_by == 4)
            begin
                count1 = count1 + 1;
                if(count1 == 3)
                begin
                    count1 = 1;
                    osc1_int = ~osc1_int;
                end
            end
            else if (divide1_by == 16)
            begin 
                count1 = count1 + 1;  
                if(count1 == 9)
                begin 
                    count1 = 1; 
                    osc1_int = ~osc1_int; 
                end 
            end
            else if (divide1_by == 64)
            begin  
                count1 = count1 + 1;   
                if(count1 == 33) 
                begin  
                    count1 = 1;  
                    osc1_int = ~osc1_int;  
                end  
            end
            else if (divide1_by == 256)
            begin  
                count1 = count1 + 1;   
                if(count1 == 129) 
                begin  
                    count1 = 1;  
                    osc1_int = ~osc1_int;  
                end  
            end
        end
        else if(osc == "internal")
        begin
            if(first_edge1 == 0)
            begin
                first_edge1 = 1;
                #1; 
            end
            else
            begin
                if (divide1_by == 4)
                begin
                    osc1_int = ~osc1_int;
                    #(int_clk * 4);
                end
                else if (divide1_by == 16)
                begin   
                    osc1_int = ~osc1_int;
                    #(int_clk * 16);  
                end
                else if (divide1_by == 64)
                begin   
                    osc1_int = ~osc1_int;
                    #(int_clk * 64);  
                end
                else if (divide1_by == 256)
                begin   
                    osc1_int = ~osc1_int;
                    #(int_clk * 256);  
                end
            end
        end
    end


    always
    begin
        if(osc == "user_clk")
        begin
            @(posedge c);

            if (divide2_by == 2)
            begin
                osc2_int = ~osc2_int;
            end
            else if (divide2_by == 8)
            begin 
                count2 = count2 + 1;  
                if(count2 == 5)
                begin 
                    count2 = 1; 
                    osc2_int = ~osc2_int; 
                end 
            end
            else if (divide2_by == 32)
            begin  
                count2 = count2 + 1;   
                if(count2 == 17) 
                begin  
                    count2 = 1;  
                    osc2_int = ~osc2_int;  
                end  
            end
            else if (divide2_by == 128)
            begin  
                count2 = count2 + 1;   
                if(count2 == 65) 
                begin  
                    count2 = 1;  
                    osc2_int = ~osc2_int;  
                end  
            end
            else if (divide2_by == 1024)
            begin  
                count2 = count2 + 1;  
                if(count2 == 513)    
                begin  
                    count2 = 1;
                    osc2_int = ~osc2_int;
                end  
            end
            else if (divide2_by == 4096)
            begin  
                count2 = count2 + 1;  
                if(count2 == 2049)    
                begin  
                    count2 = 1;
                    osc2_int = ~osc2_int;
                end  
            end
            else if (divide2_by == 16384)
            begin  
                count2 = count2 + 1;  
                if(count2 == 8193)    
                begin  
                    count2 = 1;
                    osc2_int = ~osc2_int;
                end  
            end
            else if (divide2_by == 65536)
            begin  
                count2 = count2 + 1;  
                if(count2 == 32769)    
                begin  
                    count2 = 1;
                    osc2_int = ~osc2_int;
                end  
            end
        end
        else if(osc == "internal")
        begin
            if(first_edge2 == 0)
            begin
                first_edge2 = 1;
                #1; 
            end
            else
            begin
                if (divide2_by == 2)
                begin
                    osc2_int = ~osc2_int;
                    #(int_clk * 2);
                end
                else if (divide2_by == 8)
                begin   
                    osc2_int = ~osc2_int;
                    #(int_clk * 8);  
                end
                else if (divide2_by == 32)
                begin   
                    osc2_int = ~osc2_int;
                    #(int_clk * 32);  
                end
                else if (divide2_by == 128)
                begin   
                    osc2_int = ~osc2_int;
                    #(int_clk * 128);
                end
                else if (divide2_by == 1024)
                begin
                    osc2_int = ~osc2_int;
                    #(int_clk * 1024);  
                end
                else if (divide2_by == 4096)
                begin
                    osc2_int = ~osc2_int;
                    #(int_clk * 4096);  
                end
                else if (divide2_by == 16384)
                begin
                    osc2_int = ~osc2_int;
                    #(int_clk * 16384);  
                end
                else if (divide2_by == 65536)
                begin
                    osc2_int = ~osc2_int;
                    #(int_clk * 65536);  
                end
            end
        end
    end

    specify

`ifdef SYNTH
    specparam Area = 1;
`endif

    (c => osc1) = (1, 1);
    (c => osc2) = (1, 1);

    endspecify

`endprotect

endmodule
`endcelldefine
