
primitive U_LD_P_S_R_NO (Q, D, G, R, S, NOTI_REG); 

    output Q; 
    input  D,               // DATA
           G,               // CLOCK
           R,               // CLEAR ACTIVE LOW
           S,               // SET ACTIVE LOW
           NOTI_REG;        // NOTIFY_REG

`protect

    reg    Q;                               

// FUNCTION : POSITIVE LEVEL SENSITIVE D-TYPE LATCH WITH ACTIVE HIGH
//            ASYNCHRONOUS SET AND RESET.  ( Q OUTPUT UDP ).

// Initialize output pin Q to a logical value of 0

initial
   Q=1'b0;

   table
     //  D       G      R     S    NOTI_REG       : Qt  :   Qt+1
                                  
         *       0      0     0     ?             :  ?  :    -   ;
                                  
         ?       ?      1     ?     ?             :  ?  :    0   ; // asynchro clear
     
         ?       ?      0     1     ?             :  ?  :    1   ; 
                             
         ?      (?0)    0     0     ?             :  ?  :    -   ;
         ?      (1x)    0     0     ?             :  ?  :    -   ;
                                  
         0      (x1)    0     0     ?             :  0  :    0   ;
         1      (x1)    0     0     ?             :  1  :    1   ;
         0      (0x)    0     0     ?             :  ?  :    0   ;
         1      (0x)    0     0     ?             :  ?  :    1   ;
                                  
        (?0)     1      0     0     ?             :  ?  :    0   ;
        (?1)     1      0     0     ?             :  ?  :    1   ; 
         0      (01)    0     0     ?             :  ?  :    0   ;
         1      (01)    0     0     ?             :  ?  :    1   ; 
                                  
         ?       ?      x     0     ?             :  0  :    0   ; // Reducing pessimism.
         0      (?1)    x     0     ?             :  ?  :    0   ; // Reducing pessimism.
        (?0)     1      x     0     ?             :  ?  :    0   ; // Reducing pessimism.
     
         ?       ?      0     x     ?             :  1  :    1   ; // Reducing pessimism.
         1      (?1)    0     x     ?             :  ?  :    1   ; // Reducing pessimism.
        (?1)     1      0     x     ?             :  ?  :    1   ; // Reducing pessimism.
                                  
         ?       0     (?0)   0     ?             :  ?  :    -   ;   // ignore edge on clear
         0       1     (?0)   0     ?             :  ?  :    0   ;   // pessimism .
         1       1     (?0)   0     ?             :  ?  :    1   ;  

                                  
         ?       0      0    (?0)   ?             :  ?  :    -   ;   // ignore edge on set
         0       1      0    (?0)   ?             :  ?  :    0   ;   // pessimism .
         1       1      0    (?0)   ?             :  ?  :    1   ;  

        (?1)     x      0     0     ?             :  1  :    1   ; // Reducing pessimism.
        (?0)     x      0     0     ?             :  0  :    0   ; // Reducing pessimism.
                                  
         ?       ?      ?     ?     *             :  ?  :    x   ;

   endtable

`endprotect

endprimitive
