@ECHO OFF
rem
rem vaninit.bat -- batch file to analyze Xilinx-supplied LogiBLOX
rem                VHDL source into a Vantage (Speedwave) library
rem
rem arguments are: %1 -- target directory to contain logiblox.lib
rem
rem $Header: vaninit.bat,v 1.1 96/11/25 16:18:18 randy Locked $

rem ======================================================================
rem 
rem Print banner
rem
ECHO vaninit.bat version M1.2.6--PATCH
ECHO (c) Copyright 1996 Xilinx Inc. All rights reserved.

rem ======================================================================
rem 
rem Verify command syntax
rem
IF "%1"==""                                            GOTO err_usage
rem Cannot check existence of parent directory:
rem IF EXIST does not work on directories under Win95
rem IF NOT EXIST "%1"                                  GOTO err_noparent
IF EXIST "%1\logiblox.lib\vantage.lts"                 GOTO err_libexists

rem ======================================================================
rem
rem Verify environment
rem
IF "%XILINX%"==""                                      GOTO err_noxilinx
IF NOT EXIST "%XILINX%\vhdl\src\logiblox\logiblox.vhd" GOTO err_badxilinx
IF "%VANTAGE_VSS%"==""                                 GOTO set_vantage
GOTO compile

:set_vantage
rem ======================================================================
rem
rem Attempt to set the VANTAGE_VSS variable if unset; this will
rem    work only if the WDIR is a single path AND if we are running
rem    under Windows NT (because IF EXIST will not see the V directory
rem    when running under Windows 95)
rem
IF "%WDIR%"==""                                        GOTO err_nowdir
IF NOT EXIST "%WDIR%\..\V"                             GOTO err_novandir
SET VANTAGE_VSS=%WDIR%\..\V
IF "%VANTAGE_VSS%"==""                                 GOTO err_noenvspace
ECHO vaninit: setting VANTAGE_VSS to %VANTAGE_VSS% from WDIR ...

:compile
rem ======================================================================
rem
rem Create the Vantage library to hold the LogiBLOX VHDL
rem
ECHO ---------------------------------------------------------------------
ECHO vaninit: creating Vantage/Speedwave library for LogiBLOX VHDL
ECHO ---------------------------------------------------------------------
vanlibcr "%1\logiblox.lib" LOGIBLOX
IF ERRORLEVEL 1                                        GOTO err_vanlibcr
IF NOT EXIST "%1\logiblox.lib\vantage.lts"             GOTO err_vanlibcr

rem ======================================================================
rem
rem Look for the SYNOPSYS.LIB library: if found, it will be added to
rem    the ANALYZE command line. If the Synopsys Speedwave libraries
rem    are installed, the IEEE.STD_LOGIC_1164 package will reference
rem    the SYNOPSYS.ATTRIBUTES package, and ANALYZE will fail if the
rem    SYNOPSYS.LIB is not specified
rem
IF EXIST "%VANTAGE_VSS%\PGM\LIBS\SYNOPSYS.LIB\vantage.lts" GOTO do_synlib

rem ======================================================================
rem
rem Vantage Library Set: Compile each VHDL file into the new library
rem
ECHO ---------------------------------------------------------------------
ECHO vaninit: analyzing LogiBLOX VHDL source file mvlutil.vhd
ECHO ---------------------------------------------------------------------
analyze -src "%XILINX%\vhdl\src\logiblox\mvlutil.vhd" -lib "%1\logiblox.lib" -libieee
IF ERRORLEVEL 1                                        GOTO err_analyze
ECHO ---------------------------------------------------------------------
ECHO vaninit: analyzing LogiBLOX VHDL source file mvlarith.vhd
ECHO ---------------------------------------------------------------------
analyze -src "%XILINX%\vhdl\src\logiblox\mvlarith.vhd" -lib "%1\logiblox.lib" -libieee
IF ERRORLEVEL 1                                        GOTO err_analyze
ECHO ---------------------------------------------------------------------
ECHO vaninit: analyzing LogiBLOX VHDL source file logiblox.vhd
ECHO ---------------------------------------------------------------------
analyze -src "%XILINX%\vhdl\src\logiblox\logiblox.vhd" -lib "%1\logiblox.lib" -libieee
IF ERRORLEVEL 1                                        GOTO err_analyze
GOTO finish

:do_synlib
rem ======================================================================
rem
rem Synopsys Library Set: Compile each VHDL file into the new library
rem
ECHO ---------------------------------------------------------------------
ECHO vaninit: analyzing LogiBLOX VHDL source file mvlutil.vhd
ECHO ---------------------------------------------------------------------
analyze -src "%XILINX%\vhdl\src\logiblox\mvlutil.vhd" -lib "%1\logiblox.lib" -libieee -lib "%VANTAGE_VSS%\pgm\libs\synopsys.lib"
IF ERRORLEVEL 1                                        GOTO err_analyze
ECHO ---------------------------------------------------------------------
ECHO vaninit: analyzing LogiBLOX VHDL source file mvlarith.vhd
ECHO ---------------------------------------------------------------------
analyze -src "%XILINX%\vhdl\src\logiblox\mvlarith.vhd" -lib "%1\logiblox.lib" -libieee -lib "%VANTAGE_VSS%\pgm\libs\synopsys.lib"
IF ERRORLEVEL 1                                        GOTO err_analyze
ECHO ---------------------------------------------------------------------
ECHO vaninit: analyzing LogiBLOX VHDL source file logiblox.vhd
ECHO ---------------------------------------------------------------------
analyze -src "%XILINX%\vhdl\src\logiblox\logiblox.vhd" -lib "%1\logiblox.lib" -libieee -lib "%VANTAGE_VSS%\pgm\libs\synopsys.lib"
IF ERRORLEVEL 1                                        GOTO err_analyze

:finish
rem ======================================================================
rem
rem Normal completion
rem
ECHO ---------------------------------------------------------------------
ECHO vaninit: LogiBLOX VHDL library analyzed successfully
ECHO vaninit: analysis information from file %1\logiblox.txt:
ECHO ----------------------------------------------- >  "%1\logiblox.txt"
ECHO LogiBLOX VHDL Analyzed for Speedwave Simulation >> "%1\logiblox.txt"
ECHO ----------------------------------------------- >> "%1\logiblox.txt"
ECHO Analyzed Into      : %1\logiblox.lib            >> "%1\logiblox.txt"
ECHO Vantage Directory  : %VANTAGE_VSS%              >> "%1\logiblox.txt"
ECHO Xilinx VHDL Source : %XILINX%\vhdl\src\logiblox >> "%1\logiblox.txt"

TYPE "%1\logiblox.txt"
ECHO ---------------------------------------------------------------------

GOTO exit

:err_usage
echo usage: vaninit target_path
echo ---------------------------------------------------------------------
echo This batch file will analyze the standard LogiBLOX VHDL source files
echo (provided by Xilinx) into a Vantage/Speedwave library. This new
echo library (called logiblox.lib) will be created under the specified
echo target_path. The XILINX environment variable must be defined (to
echo locate the VHDL source files), and the VANTAGE_VSS environment
echo variable must be defined (to enable the Speedwave analysis tools).
echo ---------------------------------------------------------------------
goto exit

:err_noparent
echo ---------------------------------------------------------------------
echo ERROR: The specified target directory (%1) does not exist.
echo        The new library will be created under the specified target
echo        directory, which should already exist. Create the desired
echo        target directory, or specify an existing one.
echo ---------------------------------------------------------------------
goto exit

:err_libexists
echo ---------------------------------------------------------------------
echo ERROR: A directory called "logiblox.lib" already exists under the
echo        specified target directory (%1).
echo        Remove this directory or choose a new parent directory.
echo ---------------------------------------------------------------------
goto exit

:err_noxilinx
echo ---------------------------------------------------------------------
echo ERROR: The XILINX environment variable is not set. This variable
echo        must point to the root directory of the Xilinx installation,
echo        so that the LogiBLOX VHDL source files can be found.
echo ---------------------------------------------------------------------
goto exit

:err_badxilinx
echo ---------------------------------------------------------------------
echo ERROR: The LogiBLOX VHDL source was not found in the directory
echo        %XILINX%\vhdl\src\logiblox.
echo        Check the definition of the XILINX environment variable.
echo ---------------------------------------------------------------------
goto exit

:err_nowdir
echo ---------------------------------------------------------------------
echo ERROR: Neither the VANTAGE_VSS nor the WDIR environment variables
echo        are defined. Both must be defined for the Speedwave VHDL
echo        analysis tools to work. WDIR is typically set to the STANDARD
echo        directory under the main Workview Office path; and 
echo        VANTAGE_VSS is typically set to the V directory under the
echo        main Workview Office path.
echo ---------------------------------------------------------------------
goto exit

:err_novandir
echo ---------------------------------------------------------------------
echo ERROR: The VANTAGE_VSS enviornment variable is not defined, and its
echo        value could not be derived from the WDIR variable setting.
echo        Define VANTAGE_VSS so that the Speedwave VHDL analysis tools
echo        can be used. VANTAGE_VSS is typically set to the V directory
echo        under the main Workview Office path.
echo ---------------------------------------------------------------------
goto exit

:err_noenvspace
echo ---------------------------------------------------------------------
echo ERROR: Unable to define VANTAGE_VSS environment variable. This is
echo        probably because the environment space is used up. Check the
echo        error messages above.
echo ---------------------------------------------------------------------
goto exit

:err_vanlibcr
echo ---------------------------------------------------------------------
echo ERROR: The Vantage/Speedwave library creator program (vanlibcr)
echo        failed. See the errors messages given above.
echo ---------------------------------------------------------------------
goto exit

:err_analyze
echo ---------------------------------------------------------------------
echo ERROR: The Vantage/Speedwave VHDL analyzer failed. See the error
echo        messages given above.
echo ---------------------------------------------------------------------
goto exit

:exit 


