-- ALARM.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

entity alarm is
port( TOGGLE_SWITCH,SET_TIME,
      ALARM, HRS,MINS,CLK     : in STD_LOGIC;
      SPEAKER_OUT             : out STD_LOGIC; 
      AM_PM_DISPLAY           : out STD_LOGIC;
      DISP1,DISP2             : out STD_LOGIC_VECTOR(13 downto 0));
end;

architecture BEHAVIOR of alarm is 

    component time_block 
    port( SET_TIME,HRS,MINS,CLK : in STD_LOGIC;
          CONNECT6              : buffer INTEGER range 1 to 12;
	  CONNECT7              : buffer INTEGER range 0 to 59;
	  CONNECT8              : buffer STD_LOGIC); 
    end component;

    component alarm_block
    port( ALARM,HRS,MINS,CLK : in STD_LOGIC;
          CONNECT9           : buffer INTEGER range 1 to 12;
          CONNECT10          : buffer INTEGER range 0 to 59;
	  CONNECT11          : buffer STD_LOGIC); 
    end component;

    component convertor_ckt
    port (CONNECT13   : in UNSIGNED(9 downto 0);
          DISP1,DISP2 : out STD_LOGIC_VECTOR(13 downto 0));
    end component;

    component  comparator 
    port( ALARM_HRS,CLOCK_HRS     : in  INTEGER range 1 to 12;
          ALARM_MINS,CLOCK_MINS   : in  INTEGER range 0 to 59;
	  ALARM_AM_PM,CLOCK_AM_PM : in STD_LOGIC; 
 	  RINGER                  :out STD_LOGIC); 
    end component;

    component alarm_sm_2
    port( COMPARE_IN,TOGGLE_ON : in STD_LOGIC; 
          CLOCK                : in STD_LOGIC;
	  RING                 : out STD_LOGIC); 
    end component;

    component mux
    port( ALARM_HRS     : in INTEGER range 1 to 12;
	  ALARM_MINS	: in INTEGER range 0 to 59;
	  ALARM_AM_PM   : in STD_LOGIC; 
	  TIME_HRS      : in INTEGER range 1 to 12;
	  TIME_MINS     : in INTEGER range 0 to 59;
	  TIME_AM_PM	: in STD_LOGIC; 
          ALARM_SET     : in STD_LOGIC;
	  OUTBUS        : out UNSIGNED(10 downto 0));
    end component;

--Top level nets that connect major modules

signal KONNECT7,KONNECT10           : INTEGER range 0 to 59; 
signal KONNECT8,KONNECT11,KONNECT12 : STD_LOGIC; 
signal KONNECT6,KONNECT9            : INTEGER range 1 to 12; 
signal KONNECT13                    : UNSIGNED(10 downto 0);

begin
    AM_PM_DISPLAY <= KONNECT13(0);
    U1: time_block    port map( SET_TIME,HRS,MINS,CLK,KONNECT6,KONNECT7,
                                KONNECT8);
    U2: alarm_block   port map( ALARM,HRS,MINS,CLK,KONNECT9,KONNECT10,
			        KONNECT11);
    U3: convertor_ckt port map( KONNECT13(10 downto 1),DISP1,DISP2);
    U4: comparator    port map( KONNECT9,KONNECT6,KONNECT10,KONNECT7,
			        KONNECT11,KONNECT8,KONNECT12);
    U5: alarm_sm_2    port map( KONNECT12,TOGGLE_SWITCH,CLK,SPEAKER_OUT);
    U6: mux           port map( KONNECT9,KONNECT10,KONNECT11,KONNECT6,
		                KONNECT7,KONNECT8,ALARM,KONNECT13);

end;




