-- ALARM_BLOCK.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

entity alarm_block is
port ( ALARM,HRS,MINS,CLK : in STD_LOGIC;
       CONNECT9           : buffer INTEGER range 1 to 12;
       CONNECT10          : buffer INTEGER range 0 to 59;
       CONNECT11          : buffer STD_LOGIC);
end;

architecture BEHAVIOR of alarm_block is

    component alarm_state_machine
    port( ALARM_BUTTON   : in STD_LOGIC;
	  HOURS_BUTTON   : in STD_LOGIC;
	  MINUTES_BUTTON : in STD_LOGIC;
	  CLK            : in STD_LOGIC;
	  HOURS          : out STD_LOGIC;
	  MINS           : out STD_LOGIC);
    end component;

    component alarm_counter
    port ( HOURS       : in STD_LOGIC;
	   MINS        : in STD_LOGIC;
 	   CLK         : in STD_LOGIC;
	   HOURS_OUT   : buffer INTEGER range 0 to 12;
	   MINUTES_OUT : buffer INTEGER range 0 to 59;
	   AM_PM_OUT   : buffer STD_LOGIC);
    end component;

--  Top level nets that connect major modules

signal CONNECT1,CONNECT2 : STD_LOGIC;

begin
    U1: alarm_state_machine port map ( ALARM,HRS,MINS,CLK,
				       CONNECT1,CONNECT2);
    U2: alarm_counter port map ( CONNECT1,CONNECT2,CLK,
            CONNECT9,CONNECT10,CONNECT11);
end;

