-- CONVERTOR_CKT.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

entity convertor_ckt is 
port ( CONNECT13   : in unsigned(9 downto 0);
       DISP1,DISP2 : out STD_LOGIC_VECTOR(13 downto 0));
end;

architecture BEHAVIOR of convertor_ckt is
    component convertor
    port( T0,T1,T2,T3,T4,T5: in STD_LOGIC ;
          A0,B0,C0,D0,E0,F0,G0,A1,B1,C1,D1,E1,F1,G1: out STD_LOGIC);
    end component;

    component hours_filter 
    port( TENS_DIGIT_HOURS_IN  : in STD_LOGIC_VECTOR(6 downto 0);
          TENS_DIGIT_HOURS_OUT : out STD_LOGIC_VECTOR(6 downto 0));
    end component;

    signal CONNECT14 : STD_LOGIC_VECTOR(13 downto 0);
    signal DATA_IN1  : UNSIGNED(5 downto 0);
    signal data_out1 : STD_LOGIC_VECTOR(6 downto 0);

    begin
	DATA_IN1 <= '0'&'0'&CONNECT13(9 downto 6);
	DISP1 <= CONNECT14(13 downto 7)&DATA_OUT1;
	
    U7: convertor port map(DATA_IN1(5),DATA_IN1(4),DATA_IN1(3),DATA_IN1(2),
 	    DATA_IN1(1),DATA_IN1(0),CONNECT14(13),CONNECT14(12),CONNECT14(11),
	    CONNECT14(10),CONNECT14(9),CONNECT14(8),CONNECT14(7),CONNECT14(6),
	    CONNECT14(5),CONNECT14(4),CONNECT14(3),CONNECT14(2),CONNECT14(1),
	    CONNECT14(0)); 
    U8: convertor port map(CONNECT13(5),CONNECT13(4),CONNECT13(3),CONNECT13(2),
	    CONNECT13(1),CONNECT13(0),DISP2(13),DISP2(12),DISP2(11),DISP2(10),
	    DISP2(9),DISP2(8),DISP2(7),DISP2(6),DISP2(5),DISP2(4),DISP2(3),
	    DISP2(2),DISP2(1),DISP2(0));
    U9: hours_filter port map(CONNECT14(6 downto 0),DATA_OUT1);

end;



