-- BND_SCAN.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity bnd_scan is
    port (TDI_P, TMS_P, TCK_P : in STD_LOGIC;
	  LOAD_P, CE_P, CLOCK_P, RESET_P: in STD_LOGIC;
          DATA_P: in STD_LOGIC_VECTOR(3 downto 0);
          TDO_P: out STD_LOGIC;
          COUT_P: out STD_LOGIC_VECTOR(3 downto 0));
end bnd_scan;

architecture xilinx of bnd_scan is

    component BSCAN 
        port (TDI, TMS, TCK:in STD_LOGIC;
              TDO: out STD_LOGIC);
    end component;

    component TDI
        port (I: in STD_LOGIC);
    end component;

    component TMS
        port (I: in STD_LOGIC);
    end component;
   
    component TCK
        port (I: in STD_LOGIC);
    end component;

    component TDO
        port (O: out STD_LOGIC);
    end component;

    component count4
        port (LOAD, CE, CLOCK, RST: in STD_LOGIC;
              DATA: in STD_LOGIC_VECTOR (3 downto 0);
              COUT: out STD_LOGIC_VECTOR (3 downto 0));
    end component;
  
begin

    U1: BSCAN port map (TDO => TDO_P,
        	        TDI => TDI_P, 
		        TMS => TMS_P, 
		        TCK => TCK_P);

    U2: TDI port map (I =>TDI_P);

    U3: TCK port map (I =>TCK_P);

    U4: TMS port map (I =>TMS_P);

    U5: TDO port map (O =>TDO_P);

    U6: count4 port map (LOAD  => LOAD_P, 
			 CE    => CE_P, 
			 CLOCK => CLOCK_P, 
			 RST   => RESET_P,
                         DATA  => DATA_P, 
			 COUT  => COUT_P);

end xilinx;
