-- BUFT_EX.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- This is an example that show how to infer tri-state buffers.
-- June 1995

library IEEE;
use IEEE.std_logic_1164.all;
   
entity buft_ex is
    port (DATAIN0: in STD_LOGIC_VECTOR(3 downto 0);
          DATAIN1: in STD_LOGIC_VECTOR(3 downto 0);
          SEL:     in STD_LOGIC;
          CLK:     in STD_LOGIC;
          DATAOUT: out STD_LOGIC_VECTOR(3 downto 0) );
end buft_ex;

architecture BUFT_BEHAV of buft_ex is
    signal mainline: STD_LOGIC_VECTOR(3 downto 0);

begin
  
    ADD_3STATE: process (SEL, DATAIN0)
    begin
       if (SEL = '0') then
           mainline <= DATAIN0;
       else
           mainline <= "ZZZZ";
       end if;
    end process; -- End process ADD_3STATE

    ADD_3STATE2: process (SEL, DATAIN1)
    begin
        if (SEL = '1') then
            mainline <= DATAIN1;
        else
            mainline <= "ZZZZ";
       end if;
    end process; -- End process ADD_3STATE2

    ADD_REG: process
    begin
       wait until CLK'event and CLK = '1';
       DATAOUT <= mainline;
    end process; -- End process ADD_REG

end BUFT_BEHAV;
