-- CLR_PRE_GATE.VHDL
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

-- The XC4000 device registers can perform a asynchronous
-- clear or preset but NOT both.  This design was broken
-- into two register and then muxed togther.  The CLR has
-- precedence over the Preset condition called GATE 

Library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity clr_pre_gate is
    port (ADR: in STD_LOGIC_VECTOR (5 downto 0);
          CLR, PRE, CLK: in STD_LOGIC;
	  QOUT: out STD_LOGIC);
end clr_pre_gate;

architecture BEHAV of clr_pre_gate is

signal CLR_Q, PRE_Q, GATE : STD_LOGIC;

begin

-- Process to calculate the preset condition
    PRESET: process (ADR, PRE) 
    begin
        if (ADR /= "000000" and PRE = '1') then
            GATE <= '1';
        else
	    GATE <= '0';
        end if;
    end process; -- End PRESET

-- Process to choose between CLEAR and PRESET register 
    SEL: process (CLR, PRE, PRE_Q, CLR_Q) 
    begin
        if (CLR = '0' and GATE = '1') then
            QOUT <= PRE_Q;
        else
            QOUT <= CLR_Q;
        end if;
    end process; -- End SEL

-- The asynchronous clear register, CLR_Q 
    CLEAR: process (CLR, CLK) 
    begin
        if (CLR = '1') then
            CLR_Q <= '0';
        elsif (CLK'event and CLK = '1') then
            CLR_Q <= '0';
        end if;
    end process; -- End CLEAR

-- The asynchronous preset register, PRE_Q 
    PRESET:process (PRE, CLK) 
    begin
        if (PRE = '1') then
            PRE_Q <= '1';
        elsif (CLK'event and CLK = '1') then
            PRE_Q <= '0';
        end if;
    end process; -- End PRESET

end BEHAV;
