Library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
 
entity clr_pre_gate_before is
    port (ADR: in STD_LOGIC_VECTOR (5 downto 0);
 	  CLR, PRE, CLK: in STD_LOGIC;
          QOUT: out STD_LOGIC);
end clr_pre_gate_gate_before;

architecture BEHAV of clr_pre_gate_before is
begin

    CLR_PRE: process (CLR, PRE, ADR, CLK) 
    begin
        if (CLR = '1') then
            QOUT <= '0';
        elsif (ADR /= "000000" and PRE = '1') then
            QOUT <= '1';
        elsif (CLK'event and CLK = '1') then
            QOUT <= '0';
        end if;
    end process; -- End CLR_PRE

end BEHAV;
