-- GATE_REDUCE.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_misc.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_components.all;
 
entity gate_reduce is
    port (A_CHECK:   in STD_LOGIC;
          B_CHECK:   in STD_LOGIC;
	  RESET:  in STD_LOGIC;
	  CLOCK:      in STD_LOGIC;
	  CLKEN:    in STD_LOGIC;
	  A_TICK:   in STD_LOGIC;
	  B_TICK:   in STD_LOGIC;
	  ST_A:      out STD_LOGIC;
	  ST_B:      out STD_LOGIC);
end gate_reduce;

architecture XILINX of gate_reduce is

   component xblox_dw
      Port (CHECK    	: in    STD_LOGIC;
            RST    	: in    STD_LOGIC;
            CLK    	: in    STD_LOGIC;
            CLK_EN 	: in    STD_LOGIC;
            TICK  	: in    STD_LOGIC;
            ST 		: out   STD_LOGIC );
   end component;

begin

   I_0 : xblox_dw 
      port Map (CHECK=>A_CHECK, RST=>RESET, CLK=>CLOCK, CLK_EN=>CLKEN,
                 TICK=>A_TICK, ST=>ST_A);
   I_1 : xblox_dw
      port Map (CHECK=>B_CHECK, RST=>RESET, CLK=>CLOCK, CLK_EN=>CLKEN,
                 TICK=>B_TICK, ST=>ST_B);

end XILINX;
