-- MUX_GATE16.VHD
-- 16-to-1 Mux Implemented in Gates
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- May 1995                        

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;

entity mux_gate16 is
port (	SEL: in STD_LOGIC_VECTOR (3 downto 0);
	A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P: in STD_LOGIC;
        SIG: out STD_LOGIC);
end mux_gate16;

architecture RTL of mux_gate16 is
begin
    SEL_PROCESS: process (SEL,A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P)
    begin
	case SEL is
           when "0000"  => SIG <= A;
           when "0001"  => SIG <= B;
           when "0010"  => SIG <= C;
           when "0011"  => SIG <= D;
           when "0100"  => SIG <= E;
           when "0101"  => SIG <= F;
           when "0110"  => SIG <= G;
           when "0111"  => SIG <= H;
           when "1000"  => SIG <= I;
           when "1001"  => SIG <= J;
           when "1010"  => SIG <= K;
           when "1011"  => SIG <= L;
           when "1100"  => SIG <= M;
           when "1101"  => SIG <= N;
           when "1110"  => SIG <= O;
           when others => SIG <= P;
        end case;
    end process SEL_PROCESS;
end RTL;
