-- IF_CASE.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

Library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_UNSIGNED.all;
use IEEE.STD_LOGIC_ARITH.all;

entity if_case is
     port (ADDR_A:   in std_logic_vector (1 downto 0); -- ADDRESS Code
           ADDR_B:   in std_logic_vector (1 downto 0); -- ADDRESS Code
           ADDR_C:   in std_logic_vector (1 downto 0); -- ADDRESS Code
           ADDR_D:   in std_logic_vector (1 downto 0); -- ADDRESS Code
           RESET:    in std_logic;
           CLK :     in std_logic;
           DEC_Q:   out std_logic_vector (5 downto 0)); -- Decode OUTPUT
end if_case;
 
architecture xilinx of if_case is
signal ADDR_ALL : std_logic_vector (7 downto 0);
begin

----concatenate all address lines -----------------------
ADDR_ALL <= (ADDR_A & ADDR_B & ADDR_C & ADDR_D) ;

--------Use 'case' instead of 'nested_if' for efficient gate netlist---------
    IF_CASE: process (CLK)
    begin 
        if (CLK'event and CLK = '1') then
            if (RESET = '0') then
                case ADDR_ALL is
         	    when "00011011" => 
                        DEC_Q(5 downto 4) <= "00";  
		        DEC_Q(3 downto 2) <= unsigned(ADDR_A) + '1';
                        DEC_Q(1 downto 0) <= unsigned(ADDR_B) + '1';
      	  	    when "000110--" =>
         	        DEC_Q(5 downto 4) <= unsigned(ADDR_D) + '1';
		        DEC_Q(3 downto 2) <= unsigned(ADDR_A) + '1';
         	        DEC_Q(1 downto 0) <= unsigned(ADDR_B) + '1';
                    when "0001----" =>
		        DEC_Q(5 downto 4) <= ADDR_D;
                        DEC_Q(3 downto 2) <= unsigned(ADDR_A) + '1';
                        DEC_Q(1 downto 0) <= unsigned(ADDR_B) + '1';
                    when "00------" =>
                        DEC_Q(5 downto 4) <= ADDR_D;
                        DEC_Q(3 downto 2) <= "01";
                        DEC_Q(1 downto 0) <= "00";
                    when others     =>
                        DEC_Q(5 downto 4) <= ADDR_D;
                        DEC_Q(3 downto 2) <= ADDR_A;
                        DEC_Q(1 downto 0) <= unsigned(ADDR_B) + '1';
	        end case;
	    else
                DEC_Q <= "000000";
	    end if;
        end if;
    end process;
end xilinx;
