-- NESTED_IF.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

Library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_UNSIGNED.all;
use IEEE.STD_LOGIC_ARITH.all;

entity nested_if is
    port (ADDR_A:   in std_logic_vector (1 downto 0); -- ADDRESS Code
           ADDR_B:   in std_logic_vector (1 downto 0); -- ADDRESS Code
           ADDR_C:   in std_logic_vector (1 downto 0); -- ADDRESS Code
           ADDR_D:   in std_logic_vector (1 downto 0); -- ADDRESS Code
           RESET:    in std_logic;
           CLK :     in std_logic;
           DEC_Q:   out std_logic_vector (5 downto 0)); -- Decode OUTPUT
end nested_if;
 
architecture xilinx of nested_if is
begin

---------------- NESTED_IF PROCESS --------------
    NESTED_IF: process (CLK)
    begin 
        if (CLK'event and CLK = '1') then
            if (RESET = '0') then
                if (ADDR_A = "00") then
                    DEC_Q(5 downto 4) <= ADDR_D;
                    DEC_Q(3 downto 2) <= "01";
                    DEC_Q(1 downto 0) <= "00";
                    if (ADDR_B = "01") then
                        DEC_Q(3 downto 2) <= unsigned(ADDR_A) + '1';
                        DEC_Q(1 downto 0) <= unsigned(ADDR_B) + '1';
                        if (ADDR_C = "10") then
                            DEC_Q(5 downto 4) <= unsigned(ADDR_D) + '1';
                            if (ADDR_D = "11") then
                                DEC_Q(5 downto 4) <= "00";
                            end if;
                        else
                            DEC_Q(5 downto 4) <= ADDR_D;
         	        end if;
		    end if;
                else
         	    DEC_Q(5 downto 4)  <= ADDR_D;
         	    DEC_Q(3 downto 2)  <= ADDR_A;
         	    DEC_Q(1 downto 0)  <= unsigned(ADDR_B) + '1';
                end if;
            else
	        DEC_Q <= "000000";
   	    end if;       
        end if;	
    end process;
end xilinx;
