-- ROM16X4_4K.VHD 
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995
-- Behavioral 16x4 ROM Example	

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity rom16x4_4k is
    port (ADDR: in INTEGER range 0 to 15;
	  DATA: out STD_LOGIC_VECTOR (3 downto 0));
end rom16x4_4k;	

architecture BEHAV of rom16x4_4k is

    subtype ROM_WORD is STD_LOGIC_VECTOR (3 downto 0);
    type ROM_TABLE is array (0 to 15) of ROM_WORD;
    constant ROM: ROM_TABLE := ROM_TABLE'(
	ROM_WORD'("0000"),
	ROM_WORD'("0001"),
	ROM_WORD'("0010"),
	ROM_WORD'("0100"),
	ROM_WORD'("1000"),
	ROM_WORD'("1000"),
	ROM_WORD'("1100"),
	ROM_WORD'("1010"),
	ROM_WORD'("1001"),
	ROM_WORD'("1001"),
	ROM_WORD'("1010"),
	ROM_WORD'("1100"),
	ROM_WORD'("1001"),
	ROM_WORD'("1001"),
	ROM_WORD'("1101"),
	ROM_WORD'("1111"));

begin
	DATA <= ROM(ADDR); -- Read from the ROM

end BEHAV;
