-- XBLOXGEN_EX.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

library IEEE;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_1164.all;

entity xbloxgen_ex is
    port (ASYNC_CTRL_IN, ADD_SUB_IN, CLOCK_IN, C_IN_IN, CLK_EN_IN: in std_logic;
          B_IN: in std_logic_vector(15 downto 0);
          Q_OUT_OUT: out std_logic_vector(15 downto 0);
          C_OUT_OUT: out std_logic );
end xbloxgen_ex;

architecture structure of xbloxgen_ex is

--Cut and paste from alu.vhd.------------------------------------------
--Edit the Component instantiation section and replace the signal------
--names with the actual signal names. ---------------------------------

-- The following code is a VHDL example of how to instantiate
-- the ACCUM 'alu' you have created.
--
-- The component declaration:
--
    component alu
        port (
            ASYNC_CTRL:  in  STD_LOGIC;
            ADD_SUB:  in  STD_LOGIC;
            B:  in  STD_LOGIC_VECTOR (15 downto 0);
            CLOCK:  in  STD_LOGIC;
            C_IN:  in  STD_LOGIC;
            CLK_EN:  in  STD_LOGIC;
            Q_OUT:  out  STD_LOGIC_VECTOR (15 downto 0);
            C_OUT:  out  STD_LOGIC
            );
    end component;
--
-- The component instantiation:
--

begin

        U0:  alu port map (
            ASYNC_CTRL=>ASYNC_CTRL_IN,
            ADD_SUB=>ADD_SUB_IN,
            B=>B_IN,
            CLOCK=>CLOCK_IN,
            C_IN=>C_IN_IN,
            CLK_EN=>CLK_EN_IN,
            Q_OUT=>Q_OUT_OUT,
            C_OUT=>C_OUT_OUT
            );


end structure;
