// this module produces the D_inputs to the registered outputs for PCI signals
// STOP#, DEVSEL#, and TRDY# plus
// ENDEDn which signals end of transfer
module critpath(CLK, RSTn, FRAME_INTn, IRDY_INTn, ENDEDn, NOMORE, WRrd, TRDY_SM,
           STOP_Dn, TRDY_Dn, DEVSEL_Dn, PCI_REQ, IRDY_REGn);
input CLK, RSTn, FRAME_INTn, IRDY_INTn, WRrd;
input NOMORE;// signal that address counter is at max and must end burst
input TRDY_SM;// signal from pipcon to assert TRDY_Dn
input PCI_REQ, IRDY_REGn;
output STOP_Dn, TRDY_Dn, DEVSEL_Dn, ENDEDn;
reg ENDEDn, TRDYQn, TRDY_Dn;

//ENDEDn latches the state that the burst has ended
//and is used in higher level module to terminate response
//and end transfer in preparation for next cycle
//Cycle ends on rising clock edge on which FRAME# is high and IRDY# andTRDY# are both low
wire ENDED_D = FRAME_INTn & (~ENDEDn | (~TRDYQn & ~IRDY_INTn));	
always @(posedge CLK or negedge RSTn)
begin
   if(~RSTn) ENDEDn = 1'b0;
   else      ENDEDn = ~ENDED_D;
end

//stop=retry if selected and (addr cntr at max or if initiator wait states on read)
wire STOP_Dn = ~(PCI_REQ & (NOMORE | (~WRrd & IRDY_REGn))) | FRAME_INTn;	

//combine 2 signals onto one so only need 5 for TRDY_Dn CLB	
wire TREND = ~TRDY_SM | ~ENDEDn;// this is 2nd level of logic

//gate off TRDY_Dn at cycle end or when stopping a read init wait
always @(TREND or IRDY_INTn or WRrd or FRAME_INTn or TRDYQn)
    casex({TREND, FRAME_INTn, IRDY_INTn, WRrd, TRDYQn})
         5'b1xxxx: TRDY_Dn = 1'b1;//not transferring or ended
         5'bxx10x: TRDY_Dn = 1'b1;//stop asserted on read w init wait
         5'b010x0: TRDY_Dn = 1'b1;//do only one trdy w frame high
// the following, commented out cases are covered by the default
//         5'b00x0x: TRDY_Dn = 1'b0;//normal assertion
//         5'b0011x: TRDY_Dn = 1'b0;//wait on writes
//         5'b010x1: TRDY_Dn = 1'b0;//first=last trdy on single xfer
	 default:  TRDY_Dn = 1'b0; 
    endcase

//the terms on right indicate when it is de-asserted
wire DEVSEL_Dn = ~PCI_REQ | ~ENDEDn | (FRAME_INTn & ~IRDY_INTn & ~TRDYQn);

//track the PCI signal/outfft output so it can be used herein without I/O delay
always @(posedge CLK) TRDYQn  <= TRDY_Dn;  

endmodule
