module outfft32 (c, d, t, o);
//instantiate 32 OUTFFT cells on a 32 bit bus
input [31:0] d;
input c, t;
output [31:0] o;

outfft u0 (c, d[0], t, o[0]);
outfft u1 (c, d[1], t, o[1]);
outfft u2 (c, d[2], t, o[2]);
outfft u3 (c, d[3], t, o[3]);
outfft u4 (c, d[4], t, o[4]);
outfft u5 (c, d[5], t, o[5]);
outfft u6 (c, d[6], t, o[6]);
outfft u7 (c, d[7], t, o[7]);
outfft u8 (c, d[8], t, o[8]);
outfft u9 (c, d[9], t, o[9]);
outfft u10 (c, d[10], t, o[10]);
outfft u11 (c, d[11], t, o[11]);
outfft u12 (c, d[12], t, o[12]);
outfft u13 (c, d[13], t, o[13]);
outfft u14 (c, d[14], t, o[14]);
outfft u15 (c, d[15], t, o[15]);
outfft u16 (c, d[16], t, o[16]);
outfft u17 (c, d[17], t, o[17]);
outfft u18 (c, d[18], t, o[18]);
outfft u19 (c, d[19], t, o[19]);
outfft u20 (c, d[20], t, o[20]);
outfft u21 (c, d[21], t, o[21]);
outfft u22 (c, d[22], t, o[22]);
outfft u23 (c, d[23], t, o[23]);
outfft u24 (c, d[24], t, o[24]);
outfft u25 (c, d[25], t, o[25]);
outfft u26 (c, d[26], t, o[26]);
outfft u27 (c, d[27], t, o[27]);

outfft u28 (c, d[28], t, o[28]);
outfft u29 (c, d[29], t, o[29]);
outfft u30 (c, d[30], t, o[30]);
outfft u31 (c, d[31], t, o[31]);

endmodule

////////////////////////////////////////////////////////
//
// Simulation model
//
module outfft (c, d, t, o);
input c, d, t;
output o;
reg temp;

always @ (posedge c)
  temp = d;

assign o = t ? temp : 1'bz;

endmodule