module parity(CLK, CBE, AD, PAR_D);
input CLK;
input [3:0] CBE;
input [31:0] AD;
reg [6:0] PARs;
output PAR_D;

always @(posedge CLK)
//compute and register partial parity sums
begin
	PARs[0] = ^AD[4:0];
	PARs[1] = ^AD[9:5];
	PARs[2] = ^AD[14:10];
	PARs[3] = ^AD[19:15];
	PARs[4] = ^AD[24:20];
	PARs[5] = ^AD[29:25];
	PARs[6] = ^AD[31:30] ^ (^CBE[3:1]);
end

// combine the partial paritys in two levels of logic
//PAR_D is the input to the registered output buffer
wire PARt1 = ^PARs[4:0];
wire PAR_D =  PARt1 ^ PARs[5] ^ PARs[6] ^ CBE[0];

endmodule

